<?php
header("Content-Type: text/html;  charset=ISO-8859-1",true);

ini_set("memory_limit", "128M");
ini_set("max_execution_time", 600);

// Incluso de classes
require_once("inc/classe.ssh.php");

$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));

// Funes gerais para uso com Ajax

$acao = query_string('2');

////////////////////////////////////////////////////////
/////////// Funes Gerenciamento Streaming ////////////
////////////////////////////////////////////////////////

// Funo para ligar todos os streamings de todos os servidores
if($acao == "ligar_streamings") {

	$sql = mysqli_query($conexao,"SELECT * FROM streamings where status = '1'");
	while ($dados_stm = mysqli_fetch_array($sql)) {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);

	if($status_streaming["status"] != "loaded") {
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Liga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	}

	}

	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_ligar_streamings_resultado_ok."</div>";
	
	exit();
}

// Funo para bloquear streaming
if($acao == "reiniciar_streaming") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}
	
	$login = code_decode(query_string('3'),"D");
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";
	} else {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_reiniciar_resultado_ok."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] Streaming reiniciado com sucesso pelo administrador.");
	
	}
	
	exit();
}

// Funo para bloquear streaming
if($acao == "bloquear_streaming") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}
	

	$login = code_decode(query_string('3'),"D");
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";
	} else {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Bloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml.lock; echo OK");
	
	// Desliga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	
	mysqli_query($conexao,"Update streamings set status ='2' where codigo = '".$dados_stm["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_bloquear_resultado_ok."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] Streaming bloqueado com sucesso pelo administrador.");
	
	}
	
	exit();
}


// Funo para desbloquear streaming
if($acao == "desbloquear_streaming") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}

	$login = code_decode(query_string('3'),"D");
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";	
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Desbloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml.lock /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml; echo OK");
	
	// Liga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_desbloquear_resultado_ok."</div>";
	
	mysqli_query($conexao,"Update streamings set status = '1' where codigo = '".$dados_stm["codigo"]."'");
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] Streaming desbloqueado com sucesso pelo administrador.");
	
	}
	
	exit();
}


// Funo para remover streaming
if($acao == "remover_streaming") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}

	$login = code_decode(query_string('3'),"D");
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {	
	$checar_streaming = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	
	if($checar_streaming == 0) {	
	echo "<div class='alert alert-warning text-center' role='alert'>Ateno! Streaming ".$login." no encontrado.</div>";
	exit();
	}
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";	
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/local/WowzaMediaServer/desativar ".$dados_stm["login"].";echo OK");
	
	$ssh->executar("nohup rm -rf /home/streaming/".$dados_stm["login"]."; echo ok");
	
	mysqli_query($conexao,"Delete From streamings where codigo = '".$dados_stm["codigo"]."'");
	
	// Remove as playlists
	$query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'");
	while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
	
	mysqli_query($conexao,"Delete From playlists where codigo = '".$dados_playlist["codigo"]."'");
	mysqli_query($conexao,"Delete From playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."'");
	
	}
	
	// Remove as estatisticas
	mysqli_query($conexao,"Delete From estatisticas where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove os Agendamentos
	mysqli_query($conexao,"Delete From playlists_agendamentos where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove logs
	mysqli_query($conexao,"Delete From logs_streamings where codigo_stm = '".$dados_stm["codigo"]."'");
	mysqli_query($conexao,"Delete From dicas_rapidas_acessos where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove app android
	$dados_app = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM apps where codigo_stm = '".$dados_stm["codigo"]."'"));
	
	mysqli_query($conexao,"Delete From apps where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove o apk e imagens do app android
	@unlink("../app/apps/".$dados_app["zip"]."");

	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_remover_resultado_ok."</div>";
	
	}
	
	exit();
}

// Funo para carregar o status de uma lista de streamings
if($acao == "status_streaming") {

	$porta = query_string('3');

	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	$status_conexao = status_streaming($dados_servidor["ip"],$dados_stm["porta"]);
	$status_conexao_transmissao = status_streaming_transmissao($dados_servidor["ip"],$dados_stm["porta"],$dados_stm["senha_admin"]);
	
	if($status_conexao == "ligado") {
		$status = "<i class='ik ik-check-circle text-green'>&nbsp;".lang_info_status_ligado."</i>";
	} else {
		$status = "<i class='ik ik-info'>&nbsp;".lang_info_status_desligado."</i>";
	}
	
	if($status_conexao_transmissao == "relay") {
		$status = "<i class='ik ik-check-circle text-pink'>&nbsp;".lang_info_status_relay."</i>";
	} elseif($status_conexao_transmissao == "autodj") {
		$status = "<i class='ik ik-check-circle text-green'>&nbsp;".lang_info_status_autodj."</i>";
	} elseif($status_conexao_transmissao == "aovivo") {
		$status = "<i class='ik ik-check-circle text-red'>&nbsp;".lang_info_status_aovivo."</i>";
	}
	
	echo $status;
	
	exit();
	
}

// Funo para admin/revenda acessar painel de streaming
if($acao == "acessar_painel_streaming") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}
	
	$login = code_decode(query_string('3'),"D");

	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));

	echo code_decode($dados_stm["login"],"E")."@".code_decode($dados_stm["senha"],"E");
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] Acesso administrativo ao painel deo streaming executado com sucesso.");
	
	exit();
	
}

// Funo para admin/revenda acessar painel de revenda
if($acao == "acessar_painel_revenda") {

	// Proteo Administrador/Revenda
	if(empty($_SESSION["type_logged_user"])) {
	die("<span class='texto_status_erro'>0x004 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");	
	}
	
	$codigo = code_decode(query_string('3'),"D");

	$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$codigo."'"));

	if(file_exists("inc/lang-".$dados_revenda["idioma_painel"].".php")) {
	require_once("inc/lang-".$dados_revenda["idioma_painel"].".php");
	} else {
	require_once("inc/lang-pt-br.php");
	}

	$ultimo_acesso = date('d/m/Y H:i:s',strtotime($dados_revenda["ultimo_acesso_data"]));

	$dados_geoip = unserialize(@file_get_contents("http://www.geoplugin.net/php.gp?ip=".$_SERVER['REMOTE_ADDR'].""));
	$localidade = utf8_decode($dados_geoip["geoplugin_city"])." - ".utf8_decode($dados_geoip["geoplugin_region"]);

	$_SESSION["status_acao"] = '<div class="alert alert-info text-center" role="alert">'.sprintf(lang_info_pagina_informacoes_streaming_boas_vindas,$ultimo_acesso,$localidade).'</div>';

	$_SESSION["type_logged_user"] = "cliente";
	$_SESSION["code_user_logged"] = $dados_revenda["codigo"];

	exit();
	
}
// Funo para sincronizar streaming no servidor AAC+
if($acao == "sincronizar") {

	$login = code_decode(query_string('3'),"D");
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	$aplicacao_xml = $dados_stm["aplicacao"];

    if($dados_stm["autenticar_live"] == "nao") {

    if($dados_stm["aplicacao"] == "tvstation" || $dados_stm["aplicacao"] == "live") {
    $aplicacao_xml = $dados_stm["aplicacao"].'-sem-login';
    }

    }
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/local/WowzaMediaServer/sincronizar ".$dados_stm["login"]." '".$dados_stm["senha_transmissao"]."' ".$dados_stm["bitrate"]." ".$dados_stm["espectadores"]." ".$aplicacao_xml."");

	if($dados_servidor["nome_principal"]) {
	$servidor = $dados_servidor["nome_principal"].".".$dados_config["dominio_padrao"];
	} else {
	$servidor = $dados_servidor["nome"].".".$dados_config["dominio_padrao"];
	}

	if($dados_stm["aplicacao"] == 'webrtc') {
	$ssh->executar("sed -i 's/HOSTNAME/".$servidor."/g' /usr/local/WowzaStreamingEngine/conf/".$dados_stm["login"]."/Application.xml;echo OK");

	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	}
		
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_servidores_acoes_sincronizar_resultado_ok."</div>";
	
	}
	
	exit();
	
}

////////////////////////////////////////////////////////
//////////// Funes Gerenciamento Revenda /////////////
////////////////////////////////////////////////////////

// Funo para bloquear revenda
if($acao == "bloquear_revenda") {

	// Proteo Administrador
	require_once("inc/protecao-admin.php");

	$codigo = code_decode(query_string('3'),"D");
	
	if($codigo == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {

	$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	// Bloqueia os streamings da revenda
	$query_stms_revenda = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_revenda["codigo"]."'");
	while ($dados_stm_revenda = mysqli_fetch_array($query_stms_revenda)) {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm_revenda["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";	
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Bloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm_revenda["login"]."/Application.xml /usr/local/WowzaMediaServer/conf/".$dados_stm_revenda["login"]."/Application.xml.lock; echo OK");
	
	// Desliga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm_revenda["login"]."");
	
	mysqli_query($conexao,"Update streamings set status = '2' where codigo = '".$dados_stm_revenda["codigo"]."'");
	
	}
	
	// Bloqueia as subrevendas
	
	$query_subrevendas = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_revenda["codigo"]."'");
	while ($dados_subrevenda = mysqli_fetch_array($query_subrevendas)) {
	
	// Bloqueia os streamings da subrevenda
	$query_stms_subrevenda = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda["codigo"]."'");
	while ($dados_stm_subrevenda = mysqli_fetch_array($query_stms_subrevenda)) {
	
	$dados_servidor_stm_subrevenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm_subrevenda["codigo_servidor"]."'"));
	
	if($dados_servidor_stm_subrevenda["status"] == "off") {		
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";	
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor_stm_subrevenda["ip"],$dados_servidor_stm_subrevenda["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor_stm_subrevenda["senha"],"D"));
	
	// Bloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml /usr/local/WowzaMediaServer/conf/".$dados_stm["login"]."/Application.xml.lock; echo OK");
	
	// Desliga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm_subrevenda["login"]."");
	
	mysqli_query($conexao,"Update streamings set status = '2' where codigo = '".$dados_stm_subrevenda["codigo"]."'");
	
	}
	
	}
	
	mysqli_query($conexao,"Update revendas set status = '2' where codigo = '".$dados_revenda["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_revendas_bloquear_resultado_ok."</div>";
	
	}
	
	exit();
}

// Funo para desbloquear revenda
if($acao == "desbloquear_revenda") {

	// Proteo Administrador
	require_once("inc/protecao-admin.php");

	$codigo = code_decode(query_string('3'),"D");
	
	if($codigo == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";
	} else {

	$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	// Bloqueia os streamings da revenda
	$query_stms_revenda = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_revenda["codigo"]."'");
	while ($dados_stm_revenda = mysqli_fetch_array($query_stms_revenda)) {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm_revenda["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Desbloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm_revenda["login"]."/Application.xml.lock /usr/local/WowzaMediaServer/conf/".$dados_stm_revenda["login"]."/Application.xml; echo OK");
	
	// Desliga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm_revenda["login"]."");
	
	// Liga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm_revenda["login"]."");
	
	mysqli_query($conexao,"Update streamings set status = '1' where codigo = '".$dados_stm_revenda["codigo"]."'");
	
	}
	
	// Desbloqueia as subrevendas	
	$query_subrevendas = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_revenda["codigo"]."'");
	while ($dados_subrevenda = mysqli_fetch_array($query_subrevendas)) {
	
	// Desbloqueia os streamings da subrevenda
	$query_stms_subrevenda = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda["codigo"]."'");
	while ($dados_stm_subrevenda = mysqli_fetch_array($query_stms_subrevenda)) {
	
	$dados_servidor_stm_subrevenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm_subrevenda["codigo_servidor"]."'"));
	
	if($dados_servidor_stm_subrevenda["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor_stm_subrevenda["ip"],$dados_servidor_stm_subrevenda["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor_stm_subrevenda["senha"],"D"));
	
	// Bloqueia o streaming no servidor
	$ssh->executar("mv -f /usr/local/WowzaMediaServer/conf/".$dados_stm_subrevenda["login"]."/Application.xml.lock /usr/local/WowzaMediaServer/conf/".$dados_stm_subrevenda["login"]."/Application.xml; echo OK");
	
	// Liga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm_subrevenda["login"]."");
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm_subrevenda["login"]."");
	
	mysqli_query($conexao,"Update streamings set status = '1' where codigo = '".$dados_stm_subrevenda["codigo"]."'");
	
	}
	
	}
	
	mysqli_query($conexao,"Update revendas set status = '1' where codigo = '".$dados_revenda["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_revendas_desbloquear_resultado_ok."</div>";
	
	}
	
	exit();
}

// Funo para remover revenda
if($acao == "remover_revenda") {

	// Proteo Administrador
	require_once("inc/protecao-admin.php");

	$codigo = code_decode(query_string('3'),"D");
	
	if($codigo == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$checar_revenda = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	if($checar_revenda == 0) {	
	echo "<div class='alert alert-danger text-center' role='alert'>Ateno! Revenda no encontrada.</div>";	
	exit();
	}
	
	$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	// Remove os streamings da revenda
	$query_stms = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_revenda["codigo"]."'");
	while ($dados_stm = mysqli_fetch_array($query_stms)) {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_stm["codigo"]."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/local/WowzaMediaServer/desativar ".$dados_stm["login"]."");
	
	$ssh->executar("nohup rm -rf /home/streaming/".$dados_stm["login"]."; echo ok");
	
	mysqli_query($conexao,"Delete From streamings where codigo = '".$dados_stm["codigo"]."'");
	
	// Remove as playlists
	$query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'");
	while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
	
	mysqli_query($conexao,"Delete From playlists where codigo = '".$dados_playlist["codigo"]."'");
	mysqli_query($conexao,"Delete From playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."'");
	
	}
	
	// Remove os Agendamentos
	mysqli_query($conexao,"Delete From playlists_agendamentos where codigo_stm = '".$dados_stm["codigo"]."'");

	// Remove logs
	mysqli_query($conexao,"Delete From logs_streamings where codigo_stm = '".$dados_stm["codigo"]."'");
	mysqli_query($conexao,"Delete From dicas_rapidas_acessos where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove app android
	$dados_app = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM apps where codigo_stm = '".$dados_stm["codigo"]."'"));
	
	mysqli_query($conexao,"Delete From apps where codigo_stm = '".$dados_stm["codigo"]."'");
	
	// Remove o apk e imagens do app android
	@unlink("../app/apps/".$dados_app["zip"]."");
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] Streaming removido com sucesso na remoo da revenda ".$dados_revenda["id"]." - ".$dados_revenda["email"]."");
	
	}
	
	// Remove subrevendas
	$query_subrevendas = mysqli_query($conexao,"SELECT * FROM revendas where codigo_revenda = '".$dados_revenda["codigo"]."'");
	while ($dados_subrevenda = mysqli_fetch_array($query_subrevendas)) {
	
	mysqli_query($conexao,"Delete From revendas where codigo = '".$dados_subrevenda["codigo"]."'");
	
	// Bloqueia os streamings da subrevenda
	$query_stms_subrevenda = mysqli_query($conexao,"SELECT * FROM streamings where codigo_cliente = '".$dados_subrevenda["codigo"]."'");
	while ($dados_stm_subrevenda = mysqli_fetch_array($query_stms_subrevenda)) {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm_subrevenda["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_manutencao_servidor."</div>";	
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/local/WowzaMediaServer/desativar ".$dados_stm_subrevenda["login"]."");
	
	$ssh->executar("nohup rm -rf /home/streaming/".$dados_stm_subrevenda["login"]."; echo ok");
	
	mysqli_query($conexao,"Delete From streamings where codigo = '".$dados_stm_subrevenda["codigo"]."'");
	
	// Remove as playlists
	$query_playlists = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'");
	while ($dados_playlist = mysqli_fetch_array($query_playlists)) {
	
	mysqli_query($conexao,"Delete From playlists where codigo = '".$dados_playlist["codigo"]."'");
	mysqli_query($conexao,"Delete From playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."'");
	
	}
	
	// Remove os Agendamentos
	mysqli_query($conexao,"Delete From playlists_agendamentos where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'");

	// Remove logs
	mysqli_query($conexao,"Delete From logs_streamings where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'");
	mysqli_query($conexao,"Delete From dicas_rapidas_acessos where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'");
	
	// Remove app android
	$dados_app = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM apps where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'"));
	
	mysqli_query($conexao,"Delete From apps where codigo_stm = '".$dados_stm_subrevenda["codigo"]."'");
	
	// Remove o apk e imagens do app android
	@unlink("../app/apps/".$dados_app["zip"]."");
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm_subrevenda["login"]."] Streaming removido com sucesso na remoo da sub revenda ".$dados_subrevenda["id"]." - ".$dados_subrevenda["email"]."");
	
	}
	
	}
	
	mysqli_query($conexao,"Delete From revendas where codigo = '".$dados_revenda["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_revendas_remover_resultado_ok."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_revenda["nome"]." - ".$dados_revenda["email"]."] Revenda removida com sucesso.");
	
	}
	
	exit();
}

// Funo para alterar senha de uma revenda
if($acao == "alterar_senha_revenda") {

	// Proteo Administrador
	require_once("inc/protecao-admin.php");

	$codigo = code_decode(query_string('3'),"D");
	$nova_senha = query_string('4');
	
	if($codigo == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$checar_revenda = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	if($checar_revenda == 0) {
	echo "<div class='alert alert-danger text-center' role='alert'>Ateno! Revenda no encontrada.</div>";	
	exit();
	}
	
	$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas where codigo = '".$codigo."'"));
	
	mysqli_query($conexao,"Update revendas set senha = PASSWORD('".$nova_senha."') where codigo = '".$dados_revenda["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_revendas_alterar_senha_resultado_ok."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_revenda["nome"]." - ".$dados_revenda["email"]."] ".lang_pagina_revendas_alterar_senha_resultado_ok."");
	
	
	}
	
	exit();

}

// Funo para alterar senha de um streaming
if($acao == "alterar_senha_streaming") {

	// Proteo Administrador
	require_once("inc/protecao-admin.php");

	$login = code_decode(query_string('3'),"D");
	$tipo = query_string('4');
	$nova_senha = query_string('5');
	
	if($login == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	
	if($tipo == "dj") {
	mysqli_query($conexao,"Update streamings set senha = '".$nova_senha."' where codigo = '".$dados_stm["codigo"]."'");
	} else {
	mysqli_query($conexao,"Update streamings set senha_admin = '".$nova_senha."' where codigo = '".$dados_stm["codigo"]."'");
	}
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_streamings_alterar_senha_resultado_ok."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao($conexao,"[".$dados_stm["login"]."] ".lang_pagina_streamings_alterar_senha_resultado_ok."");
		
	}
	
	exit();

}

////////////////////////////////////////////////////////
//////////// Funes Gerenciamento Servidor ////////////
////////////////////////////////////////////////////////

// Funo para ligar todos os streamings do servidor
if($acao == "ligar_streamings_servidor") {

	$codigo_servidor = code_decode(query_string('3'),"D");
	
	if($codigo_servidor == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$codigo_servidor."'"));
	
	$sql = mysqli_query($conexao,"SELECT * FROM streamings where status = '1' AND codigo_servidor = '".$dados_servidor["codigo"]."'");
	while ($dados_stm = mysqli_fetch_array($sql)) {
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);

	if($status_streaming["status"] != "loaded") {
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	// Liga o streaming no servidor
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	}
	
	}

	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_servidores_acoes_ligar_streamings_resultado_ok."</div>";
	
	}
	
	exit();
}

// Funo para sincronizar streaming no servidor AAC+
if($acao == "sincronizar_servidor") {

	$codigo_servidor = code_decode(query_string('3'),"D");
	
	if($codigo_servidor == "") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".lang_alerta_dados_faltando."</div>";	
	} else {
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$codigo_servidor."'"));
	
	$sql = mysqli_query($conexao,"SELECT * FROM streamings where codigo_servidor = '".$dados_servidor["codigo"]."'");
	while ($dados_stm = mysqli_fetch_array($sql)) {

	$aplicacao_xml = $dados_stm["aplicacao"];

    if($dados_stm["autenticar_live"] == "nao") {

    if($dados_stm["aplicacao"] == "tvstation" || $dados_stm["aplicacao"] == "live") {
    $aplicacao_xml = $dados_stm["aplicacao"].'-sem-login';
    }

    }
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/local/WowzaMediaServer/sincronizar ".$dados_stm["login"]." '".$dados_stm["senha_transmissao"]."' ".$dados_stm["bitrate"]." ".$dados_stm["espectadores"]." ".$aplicacao_xml."");
	
	}

	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_servidores_acoes_sincronizar_resultado_ok."</div>";
	
	}
	
	exit();
}

// Funo para ativar/desativar manuteno em um servidor
if($acao == "ativar_desativar_manutencao") {

	$codigo_servidor = code_decode(query_string('3'),"D");
	
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$codigo_servidor."'"));

	if($dados_servidor["status"] == "on") {
	mysqli_query($conexao,"Update servidores set status = 'off' where codigo = '".$dados_servidor["codigo"]."'");
	$status = "ON";
	} else {
	mysqli_query($conexao,"Update servidores set status = 'on' where codigo = '".$dados_servidor["codigo"]."'");
	$status = "OFF";
	}
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".sprintf(lang_pagina_servidores_acoes_ativar_desativar_manutencao_resultado_ok,$status)."</div>";
	
	} else {	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_servidores_acoes_ativar_desativar_manutencao_resultado_erro." ".mysqli_error($conexao)."</div>";
	}
	
	exit();

}

////////////////////////////////////////////////////////
//////////////////// Funes Gerais ////////////////////
////////////////////////////////////////////////////////

// Funo para mudar o status de exibio de um aviso
if($acao == "alterar_status_aviso") {


	$codigo_aviso = code_decode(query_string('3'),"D");
	
	$dados_aviso = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM avisos where codigo = '".$codigo_aviso."'"));
	
	$status = ($dados_aviso["status"] == "sim") ? 'nao' : 'sim';
	
	mysqli_query($conexao,"Update avisos set status = '".$status."' where codigo = '".$dados_aviso["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_avisos_alterar_status_resultado_ok."</div>";
	
	exit();

}

// Funo para remover um aviso
if($acao == "remover_aviso") {


	$codigo_aviso = code_decode(query_string('3'),"D");
	
	$dados_aviso = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM avisos where codigo = '".$codigo_aviso."'"));
	
	mysqli_query($conexao,"Delete From avisos where codigo = '".$dados_aviso["codigo"]."'");
	mysqli_query($conexao,"Delete From avisos_desativados where codigo_aviso = '".$dados_aviso["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".sprintf(lang_pagina_avisos_remover_resultado_ok,$acao)."</div>";
	
	exit();

}


// Funo para remover uma requisio de app android
if($acao == "remover_tutorial") {

	$codigo_tutorial = code_decode(query_string('3'),"D");
	
	$dados_tutorial = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM tutoriais where codigo = '".$codigo_tutorial."'"));
	
	mysqli_query($conexao,"Delete From tutoriais where codigo = '".$dados_tutorial["codigo"]."'");
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_tutoriais_remover_resultado_ok."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_tutoriais_remover_resultado_erro."</div>";
	
	}
	
	exit();

}

// Funo para remover uma requisio de app android
if($acao == "remover_app_android") {

	$codigo_app = code_decode(query_string('3'),"D");
	
	$dados_app = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM apps where codigo = '".$codigo_app."'"));
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_app["codigo_stm"]."'"));
	
	mysqli_query($conexao,"Delete From apps where codigo = '".$dados_app["codigo"]."'");
	
	if(!mysqli_error($conexao)) {
	
	// Remove o apk e imagens
	@unlink("../app/apps/".$dados_app["zip"]."");
	@unlink("../".$dados_app["print"]."");
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_apps_remover_resultado_ok."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_apps_remover_resultado_erro."</div>";
	
	}
	
	exit();

}

// Funo para limpar logs
if($acao == "manutencao_limpar_logs") {

	$tipo = query_string('3');
	
	mysqli_query($conexao,"Delete From ".$tipo."");
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_manutencao_limpar_logs_resultado_ok."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_manutencao_limpar_logs_resultado_erro." ".mysqli_error($conexao)."</div>";
	}
	
	exit();

}

// Funo para otimizar db
if($acao == "otimizar_db") {

	$alltables = mysqli_query($conexao,"SHOW TABLES");

	while ($table = mysqli_fetch_assoc($alltables))
	{
	   foreach ($table as $db => $tablename)
	   {
		   mysqli_query($conexao,"OPTIMIZE TABLE '".$tablename."'");
	
	   }
	}
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_manutencao_otimizar_db_resultado_ok."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_manutencao_otimizar_db_resultado_erro." ".mysqli_error($conexao)."</div>";
	}
	
	exit();

}

// Funo para limpar estatisticas
if($acao == "limpar_estatisticas") {

	$periodo = query_string('3');
	
	if($periodo == "30") {
	$data = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-30, date("Y")));
	} elseif($periodo == "90") {
	$data = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-90, date("Y")));
	} elseif($periodo == "180") {
	$data = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-180, date("Y")));
	} elseif($periodo == "365") {
	$data = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d")-365, date("Y")));
	} else {
	$data = date("Y-m-d",mktime (0, 0, 0, date("m")  , date("d"), date("Y")));
	}

	mysqli_query($conexao,"Delete From estatisticas WHERE data < '".$data."'");
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".lang_pagina_manutencao_otimizar_db_resultado_ok."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".lang_pagina_manutencao_otimizar_db_resultado_erro." ".mysqli_error($conexao)."</div>";
	}
	
	exit();

}
?>