<?php
require_once("inc/protecao-admin.php");

$total_apps = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM apps"));
$total_apps_concluida = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM apps WHERE status = '1'"));
$total_apps_erro = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM apps WHERE status != '1'"));

if($dados_config["idioma_painel"] == "pt-br") {
$lang_sortable = "Portuguese-Brasil";
} elseif($dados_config["idioma_painel"] == "en-us") {
$lang_sortable = "English";
} else {
$lang_sortable = "Spanish";
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>Administra&ccedil;&atilde;o</title>
  <link rel="stylesheet" href="/inc/materialdesignicons.min.css">
  <link rel="stylesheet" href="/inc/font-awesome.min.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.base.css">
  <link rel="stylesheet" href="/inc/vendor.bundle.addons.css">  
  <?php if($dados_revenda["tema_dark"] == "sim") { ?>
  <link rel="stylesheet" href="/inc/theme-dark.css">
  <?php } else { ?>
  <link rel="stylesheet" href="/inc/theme.css">
  <?php } ?>
  <link rel="shortcut icon" href="/img/favicon.ico" />
  <script type="text/javascript" src="/admin/inc/ajax.js"></script>
  <script type="text/javascript" src="/admin/inc/javascript.js"></script>
</head>
<body>
  <div class="container-scroller">
    <nav class="navbar col-lg-12 col-12 p-0 fixed-top d-flex flex-row">
      <div class="text-center navbar-brand-wrapper d-flex align-items-center justify-content-center">
        <a class="navbar-brand brand-logo" href="/dashboard"><span>Administra&ccedil;&atilde;o</span></a>
        <a class="navbar-brand brand-logo-mini" href="/dashboard"><i class="fa fa-lock text-yellow"></i></a>
      </div>
      <div class="navbar-menu-wrapper d-flex align-items-center justify-content-end justify-content-lg-start">
        <button class="navbar-toggler navbar-toggler align-self-center" type="button" data-toggle="minimize">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
        <ul class="navbar-nav mr-lg-2">
          <li class="nav-item nav-search d-none d-lg-block">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text" id="search">
                  <i class="mdi mdi-magnify"></i>
                </span>
              </div>
              <input type="text" class="form-control" id="busca_chave" placeholder="Busca" aria-label="search" aria-describedby="search">
            </div>
          </li>
        </ul>
        <ul class="navbar-nav navbar-nav-right">
          <li class="nav-item">
            <a class="nav-link" href="/admin/sair"><i class="mdi mdi-logout f-22 text-icones" data-toggle="tooltip" data-placement="bottom" title="Sair/logout"></i></a>
          </li>
        </ul>
        <button class="navbar-toggler navbar-toggler-right d-lg-none align-self-center" type="button" data-toggle="offcanvas">
          <span class="mdi mdi-menu text-icones"></span>
        </button>
      </div>
    </nav>
    <div class="container-fluid page-body-wrapper">
      <nav class="sidebar sidebar-offcanvas" id="sidebar">
        <ul class="nav">
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-streamings">
              <i class="fa fa-headphones text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_streaming; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-revendas">
              <i class="fa fa-users text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_revenda; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-servidores">
              <i class="fa fa-tasks text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_servidor; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-avisos">
              <i class="fa fa-info-circle text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_avisos; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-tutoriais">
              <i class="fa fa-life-bouy text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_tutoriais; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-apps">
              <i class="fa fa-android text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_apps; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-logs-acoes">
              <i class="fa fa-file-text-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_logs_acoes; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-backup">
              <i class="fa fa-shield text-icones"></i>
              <span class="menu-title">Backup</span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-estatisticas">
              <i class="fa fa-bar-chart-o text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_estatisticas; ?></span>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="/admin/admin-configuracoes">
              <i class="fa fa-cog text-icones"></i>
              <span class="menu-title"><?php echo lang_menu_configuracoes; ?></span>
            </a>
          </li>   
        </ul>
      </nav>
      <!-- partial -->
      <div class="main-panel">
        <div class="content-wrapper">
          <div id="local-status-acoes"><?php echo $_SESSION['status_acao'];unset($_SESSION['status_acao']); ?></div>
          <div class="row">            

            <div class="col-lg-12">
              <div class="card">
                  <div class="card-header">
                    <header><?php echo lang_pagina_apps_titulo; ?></header>
                  </div>
                <div class="card-body">
                    <table id="data_table" class="table dataTable no-footer table-hover" role="grid" aria-describedby="data_table_info">
                                                <thead>
                                                    <tr role="row">
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_apps_login; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_apps_revenda; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_apps_data; ?></th>
                                                        <th class="sorting_asc" tabindex="0" aria-controls="data_table" rowspan="1" colspan="1" aria-sort="ascending"><?php echo lang_pagina_apps_package; ?></th>
                                                        <th><?php echo lang_pagina_apps_acoes; ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
<?php
$sql = mysqli_query($conexao,"SELECT *, DATE_FORMAT(data,'%d/%m/%Y %H:%i:%s') AS data FROM apps ORDER by codigo DESC");
while ($dados_app = mysqli_fetch_array($sql)) {

$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_app["codigo_stm"]."'"));
$dados_revenda = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM revendas WHERE codigo = '".$dados_stm["codigo_cliente"]."'"));

if($dados_app["status"] != 1) {
$cor_status = "class='table-danger'";
}

$app_code = code_decode($dados_app["codigo"],"E");

echo "<tr id='".$app_code."' ".$cor_status.">
<td height='25' align='left' scope='col'>&nbsp;".$dados_stm["login"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_revenda["nome"]." - ".$dados_revenda["id"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_app["data"]."</td>
<td height='25' align='left' scope='col'>&nbsp;".$dados_app["package"]."</td>
<td height='25' align='left' scope='col'>&nbsp;<a href='javascript:remover_app_android(\"".$app_code."\");'><i class='fa fa-trash-o f-16 text-red'></i></a></td>
</tr>";

}
?>
                                                </tbody>
                                            </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
      <!-- modal -->                
        <div class="modal fade" id="log-sistema" tabindex="-1" role="dialog" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered" role="document">
              <div class="modal-content">
                  <div class="modal-body" id="log-sistema-conteudo" style="text-align:center"><img src="/img/ajax-loader.gif" /></div>
              </div>
          </div>
        </div>

    </div>
  </div>
  <script src="/inc/vendor.bundle.base.js"></script>
  <script src="/inc/vendor.bundle.addons.js"></script>
  <script src="/inc/theme.js"></script>
  <script>
  $('#busca_chave').keypress(function (e) {
    if (e.which == 13) {
       window.location = "/admin/admin-streamings/resultado/"+document.getElementById("busca_chave").value;
    }
  }); 
        $(document).ready(function() {

            var table = $('#data_table').DataTable({
                responsive: true,
                "lengthMenu": [[25, 50, 100, 200, -1], [25, 50, 100, 200, "Todos/All"]],
                language: {
                    "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/<?php echo $lang_sortable; ?>.json"
                },
                select: true,
                'aoColumnDefs': [{
                    'bSortable': false,
                    'aTargets': ['nosort']
                }]
            });
            $('#data_table tbody').on( 'click', 'tr', function() {
                if ( $(this).hasClass('selected') ) {
                    $(this).removeClass('selected');
                }
                else {
                    table.$('tr.selected').removeClass('selected');
                    $(this).addClass('selected');
                }
            });

        }); 
  </script>
</body>
</html>