<?php
header("Content-Type: text/html;  charset=ISO-8859-1",true);

ini_set("memory_limit", "128M");
ini_set("max_execution_time", 600);

// Incluso de classes
require_once("admin/inc/classe.ssh.php");
require_once("admin/inc/classe.ftp.php");

$dados_config = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM configuracoes"));

// Funes gerais para uso com Ajax

$acao = query_string('1');

////////////////////////////////////////////////////////
/////////// Funes Gerenciamento Streaming ////////////
////////////////////////////////////////////////////////

// Funo para ligar streaming
if($acao == "ligar_streaming") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER']) && query_string('3') != 'robot') {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_alerta_manutencao_servidor']."</div>";
	exit();	
	}

	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	
	if($status_streaming["status"] == "unloaded" || $status_streaming["status"] == "") {
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	$resultado = $ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	
	if(!preg_match('/ERROR/i',$resultado)) {

	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_ok']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_ok']."");
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_erro']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_erro']."");
	
	}
	
	} else { // J esta ligado
	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_acao_ligar_stm_resultado_alerta']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_ligar_stm_resultado_alerta']."");
	
	}
	
	exit();
}

// Funo para reiniciar streaming
if($acao == "reiniciar_streaming") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER']) && query_string('3') != 'robot') {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_alerta_manutencao_servidor']."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	$resultado = $ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance  ".$dados_stm["login"]."");
	
	if(!preg_match('/ERROR/i',$resultado)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_reiniciar_stm_resultado_ok']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_reiniciar_stm_resultado_ok']."");
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_reiniciar_stm_resultado_erro']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_reiniciar_stm_resultado_erro']."");
	
	}

	
	exit();
}

// Funo para verificar o status do streaming e autodj
if($acao == "status_streaming") {
	
	// Proteo contra sesso expirada
	if(empty($_SESSION["login_logado"])) {	
	echo "<i class='ik ik-info'></i>Sesso Expirada!|warning";
	exit();	
	}

	$login = code_decode(query_string('2'),"D");
		
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {
	echo "<i class='fa fa-info'></i>".$lang['lang_info_status_manutencao']."|secondary";
	exit();
	}

	if($dados_stm["srt_status"] == 'sim') {

		if($dados_servidor["nome_principal"]) {
		$servidor = $dados_servidor["nome_principal"].".".$dados_config["dominio_padrao"];
		} else {
		$servidor = $dados_servidor["nome"].".".$dados_config["dominio_padrao"];
		}

		$url_source_srt = "https://".$servidor."/".$dados_stm["login"]."/srt.stream/playlist.m3u8";

		$checar_url_srt = @get_headers($url_source_srt);

		if($checar_url_srt[0] == 'HTTP/1.0 404 Not Found') {

		echo "<i class='fa fa-check-circle'></i>".$lang['lang_info_status_ligado']."|success";
		exit();

		} elseif($checar_url_srt[0] == 'HTTP/1.0 200 OK') {

		echo "<i class='fa fa-video-camera'></i>".$lang['lang_info_status_aovivo']."|success";
		exit();

		} else {

		echo "<i class='fa fa-info'></i>Standby|secondary";
		exit();

		}

	}
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	
	if($status_streaming["status_transmissao"] == "aovivo") {
	echo "<i class='fa fa-video-camera'></i>".$lang['lang_info_status_aovivo']."|success";
	exit();
	}
	
	if($status_streaming["status"] == "loaded") {
	echo "<i class='fa fa-check-circle'></i>".$lang['lang_info_status_ligado']."|success";
	exit();
	}
	
	echo "<i class='fa fa-info'></i>Standby|secondary";
	
	exit();
	
}

// Funo para gravar transmisso ao vivo
if($acao == "gravar_transmissao") {
	
	// Proteo contra sesso expirada
	if(empty($_SESSION["login_logado"])) {
	
	echo "<font color=\"#FF0000\" size=\"4\"><strong>Sesso Expirada!</strong></font><br><font color=\"#FF0000\" size=\"2\"><strong>Faa login novamente.</strong></font>";
	exit();	
	}
	
	$acao_gravador = query_string('2');
		
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$_SESSION["login_logado"]."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {
	echo "<font color=\"#999999\" size=\"5\"><strong>".$lang['lang_info_status_manutencao']."</strong></font>";
	exit();
	}
	
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	
	if($acao_gravador == "iniciar") {
		
	if($status_streaming["status_transmissao"] == "aovivo") {
	
	if($dados_stm["status_gravando"] == "nao") {
	
	// Cria a pasta de gravaes
	// Conexo FTP
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$ftp->criar_pasta("/record");
	
	// Iniciar gravao	
	$arquivo = "record/rec_".date("Y-m-d_H-i-s").".mp4";
	
	$resultado = gravar_transmissao($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"],$arquivo,'iniciar');
	
	if($resultado == "ok") {
	
	mysqli_query($conexao,"Update streamings set status_gravando = 'sim', gravador_arquivo = '".$arquivo."', gravador_data_inicio = NOW() where codigo = '".$dados_stm["codigo"]."'");
	
	echo "iniciado|".$arquivo."";
	
	} else {
	
	mysqli_query($conexao,"Update streamings set status_gravando = 'nao', gravador_arquivo = '', gravador_data_inicio = '0000-00-00 00:00:00' where codigo = '".$dados_stm["codigo"]."'");
	
	echo "erro|".$lang['lang_acao_gravar_transmissao_resultado_erro']."";
	
	} // fim resultado comando
	
	} // status_gravando
	
	}  else { // status trasmissao ao vivo
	echo "erro|".$lang['lang_acao_gravar_transmissao_resultado_erro_aovivo']."";
	} // status trasmissao ao vivo
	
	}
	
	if($acao_gravador == "parar") {
	
	// parar gravao
	$resultado = gravar_transmissao($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"],"null",'start');
	
	if($resultado == "ok") {
	
	// Fix permisso dos videos gravados
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

	$ssh->executar("/bin/chown -v streaming.streaming /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"]."");
	
	$ssh->executar("mv -fv /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"]." /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"].".tmp");
	
	$ssh->executar("nohup /usr/local/bin/ffmpeg -i /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"].".tmp -c copy /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"].";rm -f /home/streaming/".$dados_stm["login"]."/".$dados_stm["gravador_arquivo"].".tmp > /dev/null 2>&1 & echo $!");
	
	mysqli_query($conexao,"Update streamings set status_gravando = 'nao', gravador_arquivo = '', gravador_arquivo = '0000-00-00 00:00:00' where codigo = '".$dados_stm["codigo"]."'");
	
	echo "parado|ok";
	
	} else {
	
	mysqli_query($conexao,"Update streamings set status_gravando = 'nao', gravador_arquivo = '', gravador_arquivo = '0000-00-00 00:00:00' where codigo = '".$dados_stm["codigo"]."'");
	
	echo "erro|".$lang['lang_acao_gravar_transmissao_resultado_erro']."";
	
	} // fim resultado comando
	
	} // acao parar	
	
	exit();
	
}

// Funo para sincronizar streaming no servidor
if($acao == "sincronizar") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	$aplicacao = ($dados_stm["aplicacao"]) ? $dados_stm["aplicacao"] : "tvstation";
	
	$aplicacao_xml = $aplicacao;

	if($dados_stm["autenticar_live"] == "nao") {
	
	if($aplicacao == "tvstation" || $aplicacao == "live") {
	$aplicacao_xml = $aplicacao.'-sem-login';
	}
	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$resultado = $ssh->executar("/usr/local/WowzaMediaServer/sincronizar ".$dados_stm["login"]." '".$dados_stm["senha_transmissao"]."' ".$dados_stm["bitrate"]." ".$dados_stm["espectadores"]." ".$aplicacao_xml."");
	
	if(preg_match('/ERRO/i',$resultado)) {
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_sincronizar_stm_resultado_erro']."</div>";
	exit();
	}

	if($dados_servidor["nome_principal"]) {
	$servidor = $dados_servidor["nome_principal"].".".$dados_config["dominio_padrao"];
	} else {
	$servidor = $dados_servidor["nome"].".".$dados_config["dominio_padrao"];
	}

	if($dados_stm["aplicacao"] == 'webrtc') {
	$ssh->executar("sed -i 's/HOSTNAME/".$servidor."/g' /usr/local/WowzaStreamingEngine/conf/".$dados_stm["login"]."/Application.xml;echo OK");

	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance ".$dados_stm["login"]."");
	}
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_sincronizar_stm_resultado_ok']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_sincronizar_stm_resultado_ok']."");
	
	exit();
	
}

// Funo para remover uma camera
if($acao == "remover_ip_camera") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$camera = code_decode(query_string('2'),"D");
	
	$dados_camera = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM ip_cameras where codigo = '".$camera."'"));
	
	mysqli_query($conexao,"Delete From ip_cameras where codigo = '".$dados_camera["codigo"]."'");
	
	if(!mysqli_error($conexao)) {
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
		
	$resultado = $ssh->executar("rm -fv /home/streaming/".$dados_stm["login"]."/".$dados_camera["stream"]."");
	
	// Reinicia o streaming
	$status_streaming = status_streaming($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	if($status_streaming["status"] == "loaded") {

	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	
	}
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance  ".$dados_stm["login"]."");
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_gerenciador_ip_cameras_remover_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_gerenciador_ip_cameras_remover_resultado_erro']." ".mysqli_error($conexao)."</div>";
	
	}
	
	exit();

}

////////////////////////////////////////////////////////
/////////// Funes Gerenciamento Playlists /////////////
////////////////////////////////////////////////////////

// Funo para carregar as playlists
if($acao == "carregar_lista_playlists") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$total_playlists = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."'"));
	
	if($total_playlists > 0) {

	$query = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by nome ASC");
	while ($dados_playlist = mysqli_fetch_array($query)) {
	
	$total_videos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."' AND tipo != 'hc'"));
	
	echo "".$dados_playlist["codigo"]."|".$dados_playlist["nome"]."|".$total_videos.";";
	
	}
	
	}
	
	exit();

}

// Funo para carregar as pastas(avanado)
if($acao == "carregar_pastas") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	$xml_pastas = @simplexml_load_file("http://".$dados_servidor["ip"].":55/listar-pastas.php?login=".$dados_stm["login"]."");
	
	$total_pastas = count($xml_pastas->pasta);

	if($total_pastas > 0) {

	for($i=0;$i<$total_pastas;$i++){
	
	$lista_pastas .= $xml_pastas->pasta[$i]->nome."|".$xml_pastas->pasta[$i]->total.";";
	
	}
	
	}
	
	echo $lista_pastas;
		
	exit();

}

// Funo para carregar videos do streaming(avanado)
if($acao == "carregar_videos_pasta") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	//die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = str_replace(" ","%20",query_string('3'));
	$ordenar = query_string('4');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
		
	$xml_videos = @simplexml_load_file("http://".$dados_servidor["ip"].":55/listar-videos.php?login=".$dados_stm["login"]."&pasta=".$pasta."&ordenar=".$ordenar."");
	
	$total_videos = count($xml_videos->video);

	if($total_videos > 0) {

	for($i=0;$i<$total_videos;$i++){
	
	$path_separacao = ($pasta == "/" || $pasta == "") ? "" : "/";
	
	$lista_videos .= $pasta.$path_separacao.utf8_decode($xml_videos->video[$i]->nome)."|".utf8_decode($xml_videos->video[$i]->nome)."|".$xml_videos->video[$i]->width."|".$xml_videos->video[$i]->height."|".$xml_videos->video[$i]->bitrate."|".$xml_videos->video[$i]->duracao."|".$xml_videos->video[$i]->duracao_segundos."|".$xml_videos->video[$i]->thumb."|".$dados_stm["bitrate"].";";
	
	}
	
	}
	
	echo $lista_videos;
		
	exit();

}

// Funo para carregar videos do streaming(avanado)
if($acao == "carregar_videos_pasta_playlists") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = str_replace(" ","%20",query_string('3'));
	$ordenar = query_string('4');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
		
	$xml_videos = @simplexml_load_file("http://".$dados_servidor["ip"].":55/listar-videos.php?login=".$dados_stm["login"]."&pasta=".$pasta."&ordenar=".$ordenar."");
	
	$total_videos = count($xml_videos->video);

	if($total_videos > 0) {

	for($i=0;$i<$total_videos;$i++){
	
	$path_separacao = ($pasta == "/" || $pasta == "") ? "" : "/";
	
	$lista_videos .= $pasta.$path_separacao.utf8_decode($xml_videos->video[$i]->nome)."|".utf8_decode($xml_videos->video[$i]->nome)."|".$xml_videos->video[$i]->width."|".$xml_videos->video[$i]->height."|".$xml_videos->video[$i]->bitrate."|".$xml_videos->video[$i]->duracao."|".$xml_videos->video[$i]->duracao_segundos."|".$xml_videos->video[$i]->thumb."|".$dados_stm["bitrate"].";";
	
	}
	
	}
	
	echo $lista_videos;
		
	exit();

}

// Funo para carregar videos do playlist
if($acao == "carregar_videos_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$playlist = query_string('2');
	
	$total_videos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$playlist."'"));

	if($total_videos > 0) {

	$query = mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$playlist."' ORDER by ordem+0,codigo ASC");
	while ($dados_playlist_video = mysqli_fetch_array($query)) {
	
	echo "".$dados_playlist_video["path_video"]."|".$dados_playlist_video["video"]."|".$dados_playlist_video["width"]."|".$dados_playlist_video["height"]."|".$dados_playlist_video["bitrate"]."|".$dados_playlist_video["duracao"]."|".$dados_playlist_video["duracao_segundos"]."|".$dados_playlist_video["tipo"]."|".$dados_playlist_video["thumb"]."|".code_decode($_SESSION["login_logado"],"E").";";
	
	// Fix - $_SESSION["login_logado"] -> mostra login pois na funcao ajax nao tem login
	
	}
	
	}
	
	exit();

}

// Funo para criar player do video(previa)
if($acao == "play_video") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}
	
	$login = code_decode(query_string('2'),"D");
	
	$video = (query_string('4')) ? query_string('3')."/".query_string('4') : query_string('3');

	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	echo '<iframe src="https://'.$dados_servidor["nome"].'.'.$dados_config["dominio_padrao"].':1443/play.php?login='.$dados_stm["login"].'&video='.$video.'" frameborder="0" width="320" height="240" scrolling="no"></iframe>';
	
	exit();

}

// Funo para criar nova playlist
if($acao == "criar_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$playlist = query_string('3');

	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));

	mysqli_query($conexao,"INSERT INTO playlists (codigo_stm,nome,comerciais,data) VALUES ('".$dados_stm["codigo"]."','".$playlist."','nao',NOW())");
	$codigo_playlist = mysqli_insert_id($conexao);
	
	if(!mysqli_error($conexao)) {
	
	echo "ok|".code_decode($codigo_playlist,"E")."";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_gerenciador_playlists_resultado_erro']." ".mysqli_error($conexao)."</div>";

	}
	
	exit();

}

// Funo para remover msica da playlist
if($acao == "remover_video") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$video = query_string('2')."/".query_string('3');

	$verifica_video = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_videos where path_video = '".$video."'"));
	
	if($verifica_video == 1) {
	
	mysqli_query($conexao,"Delete From playlists_videos where path_video = '".$video."'") or die(mysqli_error($conexao));
	
	}
	
	exit();

}

// Funo para remover uma playlist
if($acao == "remover_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<span class='texto_status_erro'>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");
	}

	$playlist = code_decode(query_string('2'),"D");
	
	$verifica_playlist = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$playlist."'"));
	
	if($verifica_playlist == 1) {
	
	mysqli_query($conexao,"Delete From playlists where codigo = '".$playlist."'");
	mysqli_query($conexao,"Delete From playlists_videos where codigo_playlist = '".$playlist."'");
	mysqli_query($conexao,"Delete From playlists_agendamentos where codigo_playlist = '".$playlist."'");

	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_remover_playlist_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_remover_playlist_resultado_erro']."</div>";
	
	}
	
	} else {
	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_info_remover_playlist_resultado_alerta']."</div>";
	
	}
	
	exit();

}



// Funo para iniciar transmisso de uma playlist pelo gerenciador de playlists
if($acao == "iniciar_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<span class='texto_status_erro'>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");
	}

	$playlist = code_decode(query_string('2'),"D");
	
	$dados_playlist_selecionada = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$playlist."'"));
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where codigo = '".$dados_playlist_selecionada["codigo_stm"]."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<span class='texto_status_alerta'>".$lang['lang_alerta_manutencao_servidor']."</span>";
	exit();	
	}
	
	// Cria o arquivo da playlist para enviar para servidor
	$total_videos_playlist = 0;
	$query_videos = mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$dados_playlist_selecionada["codigo"]."' ORDER by ordem+0,codigo ASC");
	while ($dados_playlist_video = mysqli_fetch_array($query_videos)) {
	$lista_videos .= $dados_playlist_video["path_video"].",";
	$total_videos_playlist++;
	}
	
	$config_playlist[$playlist]["playlist"] = formatar_nome_playlist($dados_playlist_selecionada["nome"]);
	$config_playlist[$playlist]["data_inicio"] = date("Y-m-d H:i:s");
	$config_playlist[$playlist]["total_videos"] = $total_videos_playlist;
	$config_playlist[$playlist]["videos"] = substr($lista_videos,0,-1);
	
	$array_config_playlists = array ("login" => $dados_stm["login"], "playlists" => $config_playlist);
		
	$resultado = gerar_playlist($array_config_playlists);

	// Envia via FTP
	// Conexo FTP
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	if($ftp->enviar_arquivo("temp/".$resultado."","playlists_agendamentos.smil")) {
	
	@unlink("temp/".$resultado."");
	
	recarregar_playlists_agendamentos($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_iniciar_playlist_stm_resultado_ok']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_iniciar_playlist_stm_resultado_ok']."");
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_iniciar_playlist_stm_resultado_erro']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_iniciar_playlist_stm_resultado_erro']."");
	
	}
	
	exit();
}

// Funo para iniciar transmisso de uma playlist pelo gerenciador de playlists
if($acao == "menu_iniciar_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}
	
	echo '<br><select name="playlist" class="form-control" id="playlist" style="width:100%;">';
		echo '<option value="" selected="selected">'.$lang['lang_info_selecionar_opcao'].'</option>';
		echo '<optgroup label="Playlists">';
		
		$sql = mysqli_query($conexao,"SELECT * FROM playlists where codigo_stm = '".$dados_stm["codigo"]."' ORDER by codigo ASC");
		while ($dados_playlist = mysqli_fetch_array($sql)) {
		
		$total_videos = mysqli_num_rows(mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."'"));
		$duracao = mysqli_fetch_array(mysqli_query($conexao,"SELECT *,SUM(duracao_segundos) as total FROM playlists_videos where codigo_playlist = '".$dados_playlist["codigo"]."'"));
		
		if($total_videos > 0) {
		echo '<option value="'.code_decode($dados_playlist["codigo"],"E").'">'.$dados_playlist["nome"].' ('.gmdate("H:i:s", $duracao["total"]).')</option>';
		} else {
		echo '<option value="'.code_decode($dados_playlist["codigo"],"E").'" disabled="disabled">'.$dados_playlist["nome"].' ('.$lang['lang_info_sem_videos'].')</option>';
		}
		
		}
		
		echo '</optgroup>
		</select><br><br><button type="button" class="btn btn-info" onClick="iniciar_playlist( document.getElementById(\'playlist\').value );">'.$lang['lang_botao_titulo_iniciar_playlist'].'</button>';
	
	exit();
}

// Funo para remover um agendamento de playlist
if($acao == "remover_agendamento") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$codigo = code_decode(query_string('2'),"D");
	
	mysqli_query($conexao,"Delete From playlists_agendamentos where codigo = '".$codigo."'");
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_remover_agendamento_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_remover_agendamento_resultado_erro']." ".mysqli_error($conexao)."</div>";
	
	}
	
	exit();

}

// Funo para remover a configurao de Vinhetas & Comerciais
if($acao == "remover_comerciais_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$playlist = code_decode(query_string('2'),"D");
	
	$dados_playlist = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$playlist."'"));
	
	mysqli_query($conexao,"Delete From playlists_videos where tipo = 'comercial' AND codigo_playlist = '".$dados_playlist["codigo"]."'");
	
	if(!mysqli_error($conexao)) {
	
	// Marca como desativado na playlist
	mysqli_query($conexao,"Update playlists set comerciais = 'nao' where codigo = '".$dados_playlist["codigo"]."'");
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_gerenciador_playlists_remover_comerciais_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_gerenciador_playlists_remover_comerciais_resultado_erro']." ".mysqli_error($conexao)."</div>";
	
	}
	
	exit();

}

// Funo para duplicar(copiar) uma playlist
if($acao == "duplicar_playlist") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}
	
	$playlist_atual = code_decode(query_string('2'),"D");
	$playlist_nova = query_string('3');

	$dados_playlist_atual = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM playlists where codigo = '".$playlist_atual."'"));	

	mysqli_query($conexao,"INSERT INTO playlists (codigo_stm,nome,comerciais,data) VALUES ('".$dados_stm["codigo"]."','".$playlist_nova."','".$dados_playlist_atual["comerciais"]."',NOW())");
	$codigo_playlist = mysqli_insert_id($conexao);
		
	$sql_playlist_atual_videos = mysqli_query($conexao,"SELECT * FROM playlists_videos where codigo_playlist = '".$dados_playlist_atual["codigo"]."'");
	while ($dados_video_playlist_atual = mysqli_fetch_array($sql_playlist_atual_videos)) {
	
	// Adiciona msica na playlist
	mysqli_query($conexao,"INSERT INTO playlists_videos (codigo_playlist,path_video,video,width,height,bitrate,duracao,duracao_segundos,tipo,ordem) VALUES ('".$codigo_playlist."','".addslashes($dados_video_playlist_atual["path_video"])."','".addslashes($dados_video_playlist_atual["video"])."','".$dados_video_playlist_atual["width"]."','".$dados_video_playlist_atual["height"]."','".$dados_video_playlist_atual["bitrate"]."','".$dados_video_playlist_atual["duracao"]."','".$dados_video_playlist_atual["duracao_segundos"]."','".$dados_video_playlist_atual["tipo"]."','".$dados_video_playlist_atual["ordem"]."')");

	}
	
	if(!mysqli_error($conexao)) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_gerenciador_playlists_duplicar_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_gerenciador_playlists_duplicar_resultado_erro']." ".mysqli_error($conexao)."</div>";
	
	}
	
	exit();

}
	
////////////////////////////////////////////////////////
///////////// Funes Gerenciamento Vdeos /////////////
////////////////////////////////////////////////////////

// Funo para criar nova pasta
if($acao == "criar_pasta") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = remover_acentos(query_string('3'));

	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$resultado = $ftp->criar_pasta($pasta);
	
	if($resultado) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_criar_pasta_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_criar_pasta_resultado_erro']."</div>";
	
	}
	
	exit();

}

// Funo para renomear uma pasta no FTP
if($acao == "renomear_pasta") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$antigo = query_string('3');
	$novo = query_string('4');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$resultado = $ftp->renomear($antigo,$novo);
	
	if($resultado) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_renomear_pasta_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_renomear_pasta_resultado_erro']."</div>";
	
	}
	
	exit();

}

// Funo para remover uma pasta
if($acao == "remover_pasta") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = query_string('3');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$resultado = $ftp->remover_pasta($pasta);
	
	if($resultado) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_remover_pasta_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_remover_pasta_resultado_erro']."</div>";
	
	}
	
	exit();

}

// Funo para renomear uma video no FTP
if($acao == "renomear_video_ftp") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = query_string('3');
	$video = query_string('4');
	$novo = str_replace(".mp4","",query_string('5'));
	
	$pasta = ($pasta == "" || $pasta == "_root_") ? '/' : $pasta;
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$resultado = $ftp->renomear($pasta."/".$video,$pasta."/".$novo.".mp4");
	
	if($resultado) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_renomear_video_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_renomear_video_resultado_erro']."</div>";
	
	}
	
	exit();

}

// Funo para remover uma msica no FTP
if($acao == "remover_video_ftp") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	$pasta = query_string('3');
	$video = query_string('4');
		
	$pasta = ($pasta == "" || $pasta == "_root_") ? '/' : $pasta;
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ftp = new FTP();
	$ftp->conectar($dados_servidor["ip"]);
	$ftp->autenticar($dados_stm["login"],$dados_stm["senha"]);
	
	$resultado = $ftp->remover_arquivo($pasta."/".$video);
	
	if($resultado) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_remover_video_resultado_ok']."</div>";
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_info_remover_video_resultado_erro']."</div>";
	
	}
	
	exit();

}

//////////////////////////////////////////////////////
/////////// Funes Gerenciamento Painel /////////////
//////////////////////////////////////////////////////

// Funo para exibir avisos
if($acao == "exibir_aviso") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$codigo_aviso = query_string('2');
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$_SESSION["login_logado"]."'"));
	$dados_aviso = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM avisos where codigo = '".$codigo_aviso."'"));
	
	$area = ($_SESSION["login_logado"]) ? 'streaming' : 'revenda';
	$codigo_usuario = ($area == "streaming") ? $_SESSION["login_logado"] : $_SESSION["code_user_logged"];

	if(!mysqli_error($conexao)) {
	
	echo "".$dados_aviso["mensagem"]."<br /><br />".$lang['lang_info_aviso_data']." ".formatar_data($dados_stm["formato_data"], $dados_aviso["data"], $dados_stm["timezone"])."<br /><br /><input type=\"checkbox\" onclick=\"desativar_exibicao_aviso('".$codigo_aviso."', '".$area."', '".$codigo_usuario."');\" style=\"vertical-align:middle;\" />&nbsp;".$lang['lang_info_aviso_desativar']."";
	
	}
	
	exit();

}

// Funo para marcar um aviso como vizualizado
if($acao == "desativar_exibicao_aviso") {

	$codigo_aviso = query_string('2');
	$area = query_string('3');
	$codigo_usuario = query_string('4');
	
	@mysqli_query($conexao,"INSERT INTO avisos_desativados (codigo_aviso,login,area,data) VALUES ('".$codigo_aviso."','".$codigo_usuario."','".$area."',NOW())");
	
	exit();

}

// Funo para remover uma requisio de app android
if($acao == "remover_app_android") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$codigo_app = code_decode(query_string('2'),"D");
	
	$dados_app = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM apps where codigo = '".$codigo_app."'"));
	
	mysqli_query($conexao,"Delete From apps where codigo = '".$dados_app["codigo"]."'");
	
	// Remove o apk e imagens
	@unlink("app/apps/".$dados_app["zip"]."");

	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_streaming_app_android_resultado_remover_app_ok']."</div>";

	exit();

}

// Funo para finalizar live em redes sociais
if($acao == "finalizar_live") {

	$codigo = code_decode(query_string('2'),"D");
    
    $dados_live = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM lives where codigo = '".$codigo."'"));

    mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$dados_live["codigo"]."'");
    
    // Finaliza no servidor
    // Conexao SSH
    $ssh = new SSH();
    $ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
    $ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
    
    $ssh->executar("echo OK;/bin/ps aux | /bin/grep ffmpeg | /bin/grep ".$dados_stm["login"]." | /bin/grep ".$dados_live["tipo"]." | /bin/awk {'print $2'} | /usr/bin/xargs /bin/kill -9");
    
    // Cria o sesso do status das aes executadas e redireciona.
    echo "<div class='alert alert-success text-center' role='alert'>Live finalizada com sucesso.</div>";
    echo "<div class='alert alert-warning text-center' role='alert'>Agora voc deve finalizar a tranmisso na sua conta do ".ucfirst($dados_live["tipo"])."</div>";

    exit();

}

// Funo para iniciar live em redes sociais
if($acao == "iniciar_live") {

	$codigo = code_decode(query_string('2'),"D");
    
    $dados_live = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM lives where codigo = '".$codigo."'"));

    $servidor = strtolower($dados_servidor["nome"]).".".$dados_config["dominio_padrao"];

    $source_rtmp = "rtmp://".$servidor.":1935/".$dados_stm["login"]."/".$dados_stm["login"]."";

    // Conexao SSH
    $ssh = new SSH();
    $ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
    $ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));

    $ssh->executar('nohup /usr/local/bin/ffmpeg -re -i '.$source_rtmp.' -c:v copy -c:a copy -bsf:a aac_adtstoasc -preset ultrafast -strict experimental -threads 1 -f flv "'.$dados_live["servidor_live"].'" > /dev/null & echo $!');

	sleep(5);

	$resultado = $ssh->executar("/bin/ps aux | /bin/grep ffmpeg | /bin/grep rtmp | /bin/grep ".$dados_stm["login"]." | /bin/grep ".$dados_live["tipo"]." | /usr/bin/wc -l");

	if($resultado > 0) {

	mysqli_query($conexao,"Update lives set status = '1', data_inicio = NOW() where codigo = '".$codigo."'");
    
    // Cria o sesso do status das aes executadas e redireciona.
	echo "<div class='alert alert-success text-center' role='alert'>Live iniciada com sucesso no servidor de streaming.</div>";
	echo "<div class='alert alert-warning text-center' role='alert'>Agora voce deve iniciar a transmissao na sua conta do ".ucfirst($dados_live["tipo"])."</div>";

	} else {

	mysqli_query($conexao,"Update lives set status = '0' where codigo = '".$codigo."'");

	// Cria o sesso do status das aes executadas e redireciona.
	echo "<div class='alert alert-danger text-center' role='alert'>Nao foi possivel iniciar a live, tente novamente.</div>";
	}
    exit();

}
// Funo para remover live em redes sociais
if($acao == "remover_live") {

	$codigo = code_decode(query_string('2'),"D");
    
    $dados_live = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM lives where codigo = '".$codigo."'"));

    mysqli_query($conexao,"Delete From lives where codigo = '".$dados_live["codigo"]."'");
    
    // Finaliza no servidor
    // Conexao SSH
    $ssh = new SSH();
    $ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
    $ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
    
    $ssh->executar("echo OK;/bin/ps aux | /bin/grep ffmpeg | /bin/grep ".$dados_stm["login"]." | /bin/grep ".$dados_live["tipo"]." | /bin/awk {'print $2'} | /usr/bin/xargs /bin/kill -9;echo OK");
    
    echo "<div class='alert alert-success text-center' role='alert'>Live removida com sucesso.</div>";
    
    exit();

}

// Funo para remover video ads
if($acao == "remover_video_ads") {

    // Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<span class='texto_status_erro'>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");
	}

	$codigo = code_decode(query_string('2'),"D");

	mysqli_query($conexao,"Delete From anuncios_videos where codigo = '".$codigo."'");
    
    echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_info_players_player_video_ads_resultado_remover_ok']."</div>";
    
    exit();

}

// Funo para exibir a msica atual tocando no streaming
if($acao == "transmissao_atual") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}
	
	$dados_wowza = total_espectadores_conectados($dados_servidor["ip"],$dados_servidor["senha"],$dados_stm["login"]);
	$total_espectadores = ($dados_wowza["espectadores"] > 0) ? $dados_wowza["espectadores"] : "0";
	$porcentagem_uso_espectadores = ($dados_stm["espectadores"] == 0 || $dados_stm["espectadores"] > 999998) ? "0" : $total_espectadores*100/$dados_stm["espectadores"];
	
	echo $total_espectadores."|".$porcentagem_uso_espectadores;
	
	exit();
	
}

// Funo para atualizar cache de pastas
if($acao == "atualizar_cache_pastas") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER'])) {
	die("<span class='texto_status_erro'>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</span>");
	}

	$porta = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where porta = '".$porta."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));

	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("/usr/bin/php /home/streaming/cache/gerar-cache-pastas.php ".$dados_stm["porta"]." > /dev/null;echo OK");
	
	echo "<div class='alert alert-success text-center' role='alert'>Cache de pastas atualizado com sucesso.</div>";
	exit();

}


// Funo para reiniciar streaming
if($acao == "reiniciar_srt") {

	// Proteo contra acesso direto
	if(!preg_match("/".str_replace("http://","",str_replace("www.","",$_SERVER['HTTP_HOST']))."/i",$_SERVER['HTTP_REFERER']) && query_string('3') != 'robot') {
	die("<b>0x001 - Ateno! Acesso no autorizado, favor entrar em contato com nosso atendimento para maiores informaes!</b>");
	}

	$login = code_decode(query_string('2'),"D");
	
	$dados_stm = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM streamings where login = '".$login."'"));
	$dados_servidor = mysqli_fetch_array(mysqli_query($conexao,"SELECT * FROM servidores where codigo = '".$dados_stm["codigo_servidor"]."'"));
	
	if($dados_servidor["status"] == "off") {	
	echo "<div class='alert alert-warning text-center' role='alert'>".$lang['lang_alerta_manutencao_servidor']."</div>";
	exit();	
	}
	
	// Conexo SSH
	$ssh = new SSH();
	$ssh->conectar($dados_servidor["ip"],$dados_servidor["porta_ssh"]);
	$ssh->autenticar("root",code_decode($dados_servidor["senha"],"D"));
	
	$ssh->executar("mkdir /home/streaming/".$dados_stm["login"].";echo 'srt://0.0.0.0:".$dados_stm["srt_porta"]."' > /home/streaming/".$dados_stm["login"]."/srt.stream;echo OK");
	
	$ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin shutdownAppInstance ".$dados_stm["login"]."");
	$resultado = $ssh->executar("/usr/bin/java -cp /usr/local/WowzaMediaServer JMXCommandLine -jmx service:jmx:rmi://localhost:8084/jndi/rmi://localhost:8085/jmxrmi -user admin -pass admin startAppInstance  ".$dados_stm["login"]."");

	// Inicia o streaming da camera
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, "http://".$dados_servidor["ip"].":555/streammanager/streamAction?action=startStream&vhostName=_defaultVHost_&appName=".$dados_stm["login"]."%2F_definst_&streamName=srt.stream&groupId=&mediaCasterType=srt");
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_TIMEOUT, 5);
	curl_setopt($ch, CURLOPT_USERPWD, "admin:".code_decode($dados_servidor["senha"],"D").""); 
	curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_DIGEST); 
	curl_setopt($ch, CURLOPT_USERAGENT, 'Painel de Streaming 3.0.0');
	ob_start();
	$resultado = curl_exec($ch);
	curl_close($ch);

	sleep(5);

	$resultado_proc = $ssh->executar("netstat -anp | grep java | grep -c :".$dados_stm["srt_porta"]."");
	$resultado_proc = str_replace("\n","",$resultado_proc);
	
	if(preg_match('/Connecting/i',$resultado) && $resultado_proc > 0) {
	
	echo "<div class='alert alert-success text-center' role='alert'>".$lang['lang_acao_reiniciar_stm_resultado_ok']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_reiniciar_stm_resultado_ok']."");
	
	} else {
	
	echo "<div class='alert alert-danger text-center' role='alert'>".$lang['lang_acao_reiniciar_stm_resultado_erro']."</div>";
	
	// Insere a ao executada no registro de logs.
	logar_acao_streaming($conexao,"".$dados_stm["codigo"]."","".$lang['lang_acao_reiniciar_stm_resultado_erro']."");
	
	}

	
	exit();
}
?>