$.fn.extend({ChatSocket: function(opciones) {
					var ChatSocket=this;
				
                    var idChat=$(ChatSocket).attr('id');
					defaults = {
		                  ws:"",
                          Room:"RoomDeveloteca",
                          pass:"hKJHGKL453JHGKL4235kljg345lig",
                          lblTitulChat:"Chat",
                          lblCampoEntrada:"Mensagem...",
                          lblEnviar:"OK",
                          msg:"Bem vindo!",
                          Nombre:"Anonimo",
                          urlImg:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAAsQAAALEBxi1JjQAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAJ2SURBVEiJvZQ7TBRRFIa/c2dngX0Rw0s0YjBgBIOJjUalwAaRxgoxtJZSWFipEWJrYzQaCytMtDAqiYWv0oKYGAsLQ0R8oIkRX+zC8tjZucdieQi7srtA/JNJ5p475/sn5557hBw6de7NdhPgvCotQCDXN6tK+aTCjWsXm5/Jyr3e/uEtWPsaqCgavNIG6TJZYev3bgAcQAS9kG2g0rQB8AwKdgtA26B2T/l6NgjlW520F/LTJUJW9XJDfKv6K1maGvlR7aolGhKMWcqVQ/f1zDdPL0UM7ImAKYybbeT5ifjTtzGT9qmpCODM18YkfO1XhfqytcMBxHVi4cbKpG9hMukvxs2MJQwQctYOX5BTEUoCeEt8jOr8yzr+fkFixAIsMAGyu2iD9X8N9lVbenb6VJUpsSB0NVhaay0AHXWWngafoAM7opYTjZbGcs0J/adBTQiiLlSXKptKFBGlPpKBRF2oKoNwQKmNQImj1IXzGkwtG2SPxwx1UctoPOOravg5mzn9J58NsaDye04Y+iqMT1tGJ/NW+PkyA8+yCAcYm1pqrUQKEqnM2gIj8Xxw/aLGnC5+FK8icQPfQyXyXhzzMmBSfZf7904EjIDVzOOs9y5Eg8N3rrQc/ztkQoY4wKSfO6cYqcqLlTETC0qvI+iHaUjn77rV9Go6wfWVQQE4PKj7Zyx9Dlq92dV3sSBxbDZhwpfWGZ/mcACimdk1C3pbMEMRy62rnTKX06BQHbinN8c9PVnpQlMYz4ocGzgij1bLKWpUpFTbASqCeFalOx+8KIO2h7orkWabK/hhRzoGjsqDQvIKvgfW42DMZSRqpP1up3wsNO8PAB3afTgmrooAAAAASUVORK5CYII=",
                          btnEntrar:"btnEntrar",
                          btnEnviar:"btnEnviar",
                          lblBtnEnviar:"OK",
                          lblTxtEntrar:"txtEntrar",
                          lblTxtEnviar:"txtMensaje",
                          lblBtnEntrar:"OK",
                          idDialogo:"DialogoEntrada",
                          classChat:"",
                          idOnline:"listaOnline",
                          lblUsuariosOnline:"Online",
                        lblEntradaNombre:"Nome/Name/Nombre:",
                        panelColor:"success"
        			}
					
                     var opciones = $.extend({}, defaults, opciones);
		
                     var ws;
                     var Room=opciones.Room;
                     var pass=opciones.pass;
                     var lblTitulChat=opciones.lblTitulChat;
                     var lblCampoEntrada=opciones.lblCampoEntrada;
                     var lblEnviar=opciones.lblBtnEnviar;
                     var msg=opciones.msg;
                     var Nombre=opciones.Nombre;
                     
                     var urlImg=opciones.urlImg;
                     var btnEntrar=opciones.btnEntrar;
                     var btnEnviar=opciones.btnEnviar;
                     var lblBtnEnviar=opciones.lblBtnEnviar;
                     var lblTxtEntrar=opciones.lblTxtEntrar;
                     var lblTxtEnviar=opciones.lblTxtEnviar;
                     var lblBtnEntrar=opciones.lblBtnEntrar;
                     var idDialogo=opciones.idDialogo;
                     var classChat=opciones.classChat;
                     var idOnline=opciones.idOnline;
                     var lblUsuariosOnline=opciones.lblUsuariosOnline;
                     var lblEntradaNombre=opciones.lblEntradaNombre;
                     var panelColor=opciones.panelColor;
					 
					 if( $('#'+idOnline).length==0 )
                    {
                     idOnline=idChat+"listaOnline";
                        $('#'+idChat).append('<br/><div id="'+idOnline+'" style="display:none;"></div>');
                        
                    }
    
            function IniciarConexion(){
                    conex='{"setID":"'+Room+'","passwd":"'+pass+'"}';
                    ws= new WebSocket("wss://cloud.achex.ca");
                    ws.onopen= function(){ ws.send(conex); }
                    ws.onmessage= function(Mensajes){
                    var MensajesObtenidos=Mensajes.data;
                    var obj = jQuery.parseJSON(MensajesObtenidos);
                    AgregarItem(obj);
                    
                    if(obj.sID!=null){
                        
                                                      
                    if( $('#'+obj.sID).length==0 && $('#'+obj.Nombre).length==0 )
                    {
					if ( $('[title="' + obj.Nombre  + '"]').length === 0 ) {
                      $('#listaOnline').append('<li class="list-group-item" title="'+obj.Nombre+'">'+obj.Nombre+'</li>');
					}
                    }
                     
                    }
                    
                }
                ws.onclose= function(){
                    alert("Ooops!\n\nConexao encerrada, tente novamente!\nConnection closed, try again!\nConexion cerrada, vuelve a intentarlo!");
                }
          }
		  
           IniciarConexion();
		   
          function iniciarChat(){
            Nombre=$('#'+lblTxtEntrar).val();
			
			if(Nombre){
			
			// Faz loop no UL a procura de nomes iguais pelo ID
			if ( $('[title="' + Nombre  + '"]').length === 0 ) {
			
            $('#'+idDialogo).hide();
              
            CrearChat(); 
			UsuarioOnline(); //
            getOnline(); //
			
			} else {
			alert("Ooops!\n\nO nome escolhido ja esta em uso.\nThe nick is already in use.\nEl nombre ya esta en uso.");
			}
			
			} else {
			alert("Ooops!\n\nInforme seu nome.\nType your nick.\nIntroduzca su nombre.");
			}
          }
           
          function CrearEntrada(){
          $('#'+idChat).append('<div id="'+idDialogo+'" class="'+classChat+'" id="InputNombre"><div class="panel panel-'+panelColor+'"><div class="panel-heading"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAApgAAAKYB3X3/OAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHjSURBVEiJY/z//z8DLQGjfMFiSWYG5sh/DIy85BrCxPD/81+Gv8sf9Mc8R5dj4WRnPyAnI6HEx8fFQq4Fnz59+/PoyYt0BgYGdQwLfv78o+Zob0iu2XBzZs3brIZNgolSkwnaDGM8e/6W4fmLNxgKjA0xfM3w7PlbFL6UpDCcrVy4rAHCYvz0l+HvcrLDHQf4n+euy8DAwMDw8O2XP/uuPkuHWyAlKYziEnwAn7p8D10Yk0WpcLkawSAiBCQlRPBaSL9IJiWIyLJgNIhwAdr7gJ2d5db+g+fxFnZqqrIMP378Ynj0+CVW+U+fvv1REOP7xcDAwIVhwfefPx3u3H2CUlz7GMg6qEjwOzAwMDCcvPOS4dCR9wzv3n74nWCrysrGwoxhAY8cN4uvkQl2B/7//x8DZ80/fOA/FEzYfum/avHKPyfuvPxPKlAsWPYfq63bLz62h7GDzZQYnLSlmXVlhXCFIF6A1QI+TrZbRUuPK8kL88Dl9119CpeXFuJmCDRRZFh05BbDp2+/sBr88O2XP3ycbPcYsdXJCoVL8FajjAz/Gxw0pb6duvvy/Ndf/3ZjUwOrRrFaQAgoFS7/z8vJspP17XvfMzPTfuNTS1Z98J/xf4AQu+jW/TND/xBSS5YPSAEA2Kn1gypQ1iYAAAAASUVORK5CYII=">&nbsp;'+lblTitulChat+'</div><div class="texto-padrao" style="margin:5px;">'+msg+'</div><div class="panel-footer" style="margin-top:30px;"><div class="input-group"><input id="'+lblTxtEntrar+'" type="text" class="form-control input-sm" placeholder="'+lblEntradaNombre+'"><span class="input-group-btn"><button id="'+btnEntrar+'" class="btn botao btn-sm" >'+lblBtnEntrar+'</button></span></div></div></div></div>');
		  
		 
              $("#"+lblTxtEntrar).keyup(function (e) {if (e.keyCode == 13) { iniciarChat(); }});
              $("#"+btnEntrar).click(function(){
			  $('#total_online').html(0);
			  //$('html, body').animate({scrollTop: '+=301px'}, 800);
			  iniciarChat();
              });
          }
          function CrearChat(){
             $('#'+idChat ).append( '<div class="'+classChat+'"><div class="panel panel-'+panelColor+'"><div class="panel-heading"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAABHNCSVQICAgIfAhkiAAAAAlwSFlzAAAApgAAAKYB3X3/OAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAAHjSURBVEiJY/z//z8DLQGjfMFiSWYG5sh/DIy85BrCxPD/81+Gv8sf9Mc8R5dj4WRnPyAnI6HEx8fFQq4Fnz59+/PoyYt0BgYGdQwLfv78o+Zob0iu2XBzZs3brIZNgolSkwnaDGM8e/6W4fmLNxgKjA0xfM3w7PlbFL6UpDCcrVy4rAHCYvz0l+HvcrLDHQf4n+euy8DAwMDw8O2XP/uuPkuHWyAlKYziEnwAn7p8D10Yk0WpcLkawSAiBCQlRPBaSL9IJiWIyLJgNIhwAdr7gJ2d5db+g+fxFnZqqrIMP378Ynj0+CVW+U+fvv1REOP7xcDAwIVhwfefPx3u3H2CUlz7GMg6qEjwOzAwMDCcvPOS4dCR9wzv3n74nWCrysrGwoxhAY8cN4uvkQl2B/7//x8DZ80/fOA/FEzYfum/avHKPyfuvPxPKlAsWPYfq63bLz62h7GDzZQYnLSlmXVlhXCFIF6A1QI+TrZbRUuPK8kL88Dl9119CpeXFuJmCDRRZFh05BbDp2+/sBr88O2XP3ycbPcYsdXJCoVL8FajjAz/Gxw0pb6duvvy/Ndf/3ZjUwOrRrFaQAgoFS7/z8vJspP17XvfMzPTfuNTS1Z98J/xf4AQu+jW/TND/xBSS5YPSAEA2Kn1gypQ1iYAAAAASUVORK5CYII=">&nbsp;'+lblTitulChat+'&nbsp;(<span id="total_online">1</span>)</div><div class="panel-body"><ul class="chatpluginchat"></ul></div><div class="panel-footer"><div class="input-group"><input id="'+lblTxtEnviar+'" type="text" class="form-control input-sm" placeholder="'+lblCampoEntrada+'" /><span class="input-group-btn"><button  class="btn botao btn-sm" id="'+btnEnviar+'">'+lblEnviar+'</button></span></div><div id="emojis"><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAFAklEQVRIx8VVaWxUZRQ9960zfdMZ22mhFLqSAg0UlCWoFaVlsZVUsYoGxESiYLXgPzVIDAWJWBKTxqRiXMKaYIIKCrSyWaWVaqrS2rAUaFrALlAK05lOZ9685fqj0gWCwA/j9+flvXffd+53znnnAv/xon97mT8J3vwsFExPwSOp8TRecYpeAIiErO7WLj5T14rqykbs+/4krt8TwKLpGLM6H+vTxrmWqEmxihwXTYJLBRGBmRkA2b06G10B0i92h5rPBbe/X4GSb/5A5x0BtizD4qdmOT/R7k+OlmK1u6LBvNqLYP1F39fHwi8v3449twXYW4yVOTmxH7mmpoBEgQCAmZmIBupu3A99zswMm6n3txb7SJVvxTOb8cUtABsLMe/15++rdM1MFwEM+/huAIiI2GYEas+b5bv9c9bswbEBgEmjoVa9I52JmT8xhWQRANATYJTv1NF+2cbCeQrmZkvDaNl72MDhagNjU0W8tkSF0/FPAxEL1w6dPD9nozmxsQ2GBADFOVgaNWFUiqBIAx0Vr+2juj8tMDMfrjFpy6YoZE+Twcy876hBb5eGGAAdOW7iUrvNZe9G9Z9SEVmbkJBRnPvXkqId2CYBQP5kWqomxw50FwoD9acsLMiR8WyejFXr+vDLCQvZ02QAwM+/m4iLIXy0Ngof79RRe8Icdjo1xYsnJre9CPA2mpoM5egGl9/96DhlaNE1HyPGQyAC/L0MzUkQ+9mDHgEiBhCtAZYFBEMMt2u4If0/NemPlwQ9Ulocxopuh3qzsN6YQRd5ooVhIjtUIlXpF1aSALfrVlOIHqcjPS6YLrmd8AqKxADBV9XKIBGCakCIUlhwyBBUCSSLTKIAEAFgwAazZYMNk23dhB0yYPfpbJvREJ1huGYks6BIcDsRJzHfsCtzee1oWli8E5lpXrYDF8jubQeHu9nWewhmCGybAIFJUIgcUUxuD0nOeAiuRBaiU6nm13qcOrici2YM2l8KhNFt6yZgMxSviacLC5GZmYm8vDxkZ2cjM7MADmVQHma+ERno6+tDQ0MDqr86isrKSrS1taH0TRdgA3bYhD+Eq/RAEpQf3tP87ocylG4fU/6rQfgCgz+RLMuclJREI0aMgKZpYGYOBALU0dHB7e3tZNv2AO+piYT9mzWWJZD/+Lnw/HVBj3TiEiK+y33HtV5jdoxD5A9WqijepMOy+smLRCJobm7m5ubmoSbhm65QZXDpKhWiacMKWdxzJVhT14qIBAD763nHSxnds9WRXnosE/iwSObVnxsUjvRv8uDIeJo7JhEp0RosZj7r89OBC5e4yecnANAc4LJimbISGdxrsd7ZTQcasH0gKjIToPy4WjztTk9PJ1EAAG7pZCr71sKCpDA/7J1MMBIAS+vvWgwQyx28u7WR6ns0vFUo8pi4/r3Ystjf3HJ2dqmVdboDxoDaJU8i94087ZDDkyAMzVjbMGCGe2GbkX4XASBBgiCpkBwaBFkeQhwj3NNpllX05a7fj5pb4vrLFSiaP8VVrkbHE9E9xjWY9MAV62B98JXFn2HrbQfO5hfw3KKZyqeqK84jys67ArAiIdaDXdd31RrLVu3Cd3ccmQVTMHrNApRkjHIslVSXKspOkCgPq2HLgGWEYOqBcFObvnXDAayraMTlexr6uRMQm5+FghmpmJUWh/FRquglAEHdutrShTN1raiuaMS+qib48H+tvwGZeHvbKgF5fgAAAABJRU5ErkJggg==" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' :)\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEPUlEQVRIx8VVa0xTZxh+3nNOz2lpaQkto4piqSGAskFkIzNOIWCMskt2YRcTtjk2tylkP7Y/xjAjcRr3Zz82nTMmRsEsi4nRxbFMF8emmzNh2TBIYEECc+MiUCiX0tOenvPuB6WhMG5Zln2/vsv7vc/z3oH/eNFCj9tz4dyRiyce9uAxj4uylATRCQChoO7rHuT2pm7c+LoFl6+2wr8sgPICrNpfhoMZmbYKZXWybEpJJMGmgIjAzAwGGQGVtcFxCt0bDnZ2BM4ebkDtxd/QvyjA6V146ektlpPW/PREKdm6JDdEhiYQaL7nv3Bdrdxdh0vzAlzci6qSkuRPbBvWgESBAICZmYhictPnmffMzNCZJn7pMr5t9O8u/wyn5wAceQZbq15M+sb2qFcEEPd5KQBERGwwxn++Gzl2fqy05hKuxwBy06B8t19qS9623kMm8V9lDYd1DF9tvVtyJLL+Ti80CQD2FqPCmu32CLIUYxT8vZ8EkwjFm7KgBWrnAAxNZ0uWe0pMFtma7c6sLv1r59v1qJMAoCyPKpR0JwBgsrUH4f5R6OMq7JsyF2Us2i0I/NSBcM8IZLcDlnUroaxxouyhnlcArpM2pEN2uBM2kkmcChYRTKkOJBZmsGAzx1jHuSF6ZmaWXDYkleZA/WOYETWUTCInPpCwqTAjIEsZLqwV7RZlOrAJ61binwK4UJAFm5mtuWlx8qLDYva6Al7JboFTkCWeyWzAx0iyg2XTlNIBn8HJDoIYjX9YYx72M1JdYADQIsDYhMHOJIqREGQJdgtcUtR4AsAUzar3Pwqyz8/0WrmM3gHm4/UqfXwgAUWFEhjgW79GqLp2kqsqFFrlFnDmQpiTk4hOfpAAnqEHAKRxFT4jFAEMjpXFgSoz3jsaxLuHgzDLwK5nZWwpEAEDABibC0RUPifj+LkQ1BCQnyOiZo859g4QDDWCsSCGKH815MZD1jH7xkx5RuExABoPMMwysckUV/HTTFjTQGqYkWglnv137GaHuq024JCa/0TYf3/ypnVCKyZJnJktbBUB6AxDB8+uJwAQozKGyrE7AGBN59GBwI9N3QhLANBwm8+9mukrVlKdNIvl7H2cBfPIcKjfRw23URdrFTkrIH+/T2yze71eEoU5H/bVG/TDHY4DKMolPvqyMAeAdZ3HOrs6ij/Uc9v6oq2irQ/hE9f0N98x9V4xO9xCVHVMY5EH7BDiXZSfzjD8RpxLwYA62hf59Jr+elsftDnt+vxb2LM1z3ZMsaUQ0TLbNZhC4wP6lebAGztP4cy8A+dEBV54vlA+pdhcdtFkWRKAHg5yKDA48sUtrbL6c3y56Mh8Kg9pNY+jdu0Kc4Wk2GRRtoAEU7yPdA26FkQkNKF29KpnD32Fgw0tuL+soV+aDeeOB/HkIx5sznAhy6JMDf1gWB/qGkR7UzduNLTgcmM7RvB/rb8B/Oka3QhY3yYAAAAASUVORK5CYII=" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' :(\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAFM0lEQVRIx8WVW4xV5RXHf2vv75y995lzZoY5B4ujzDCHjtdBLZ2WaosOoiZoCalEjRbTWkURtGnSvlj7YBt7ebAvbSmNjRHpBRPTilWhNJpRNKUJpKKIgA7jgMIMnBnmcq5777P36sMBZLDU+tD0e/mSb13+X9Z/rf+C//GR/2Rc0kN2yTyW9nbylTkz5cKkZ2cBgmo0NlTQfTuGeG3Lbp7/6x7GPxXALb2c/9ASftR1QfoOZ3ZbMpHLiJV2EBFUVQGJS76GhaL4h8aqB94rb/jJZh758z8Z+USAJ+/i9mULvd80XdGRMW1N/1UZ6qMlyrsOTfxpW+3ulRt49qwAm9bwwKJFbb9Iz+9EbEsAVFGRj/xUVUVETt4n34hVSjvfj1/qn7h3+Tqe+BjAT2/m+tW3tW5JL8jbgPpHE/Lm99op7mxRd25ZLnvsMM0X+6iqFve78vZD7VodTEnrgknm/WxYk22RaKwUtw/U1z4ztfjhZ9l2CqDnPJwtK1P7ju3s66wcbKLtqhJT77iwpxNjDHEcU205zMKXB0Bh2+JuUlPtWJZFGIbYnx/Caw8Z357B6ygx68pXBm56snzp7sOEBmBNHysGnujrdMrd4poExzfWtFKrSHZGAlVV27Yl/DBDMGYTh6L1I2mxmi0VEUkmk4y9mtUw1SRNjkv4RqgD+6R7zaIX7lj1e54yAIs7vBUHj7WTaU0C4LoujuNMI1KtCNMUo5GgxNNsM1pnYFkWAMYYotFZXNfh3QnVp8z8DpLZvLnyoBecbMEGOQ0eAYiiSDPzJ7DcRuL0FRMaD7RiWZae8J0WS5OvM/L2l7/YRdJ05ZibmOk4XQ8O66Gfe5JJZwCmdUipXJKe+8ZOJcrfPyp7VuW0pblFzugspopTOvf7w5LIuW4+V8qbZo+slTTadfdx4kD04C/PJ+01Y2yjAEEQ0HLtiOauLnPykzOvKWvr9cNUtznqJBulDOuhlqqTdH33QzrvHNfqO4Zmj5w5ESOgmv/WhGQvEQbWVXR8V0qchEucO669Px4RoeGooIJKz6Mj+o/lKamMZAlCXzOXlWX+A+O0LJhUQU+1vynWGIv9OsQKoZBqVy5dHVE7EnJ8sMg5N4xjUjEf8aqAYFzlc4+NMrwppu2zLt7sCPvcRg4SENfqTFUZNYMFDkSTVZ9Qk1DHSgRouoI3J2B2j4+draJRBKdxqCgaK+45NTqWF4lLAZJsxEIdDWOiyWrtQIFB88YHBBNHK39vKoV9YscqqSI2ARpZKsk6a58r8vgmXy/OW1zQYaHAe4di3TsYc9/XAr3/xgjxDI1YH62HxLVIJ4+VX98xRGAAXtilv/tm91if85msQIQYX8UgCPxxq69hHXnr3Zi33o2nadHGrb6s/qogzom6hYqGqD8yJi++yQYAA/Drfv5w65cKPzCJTF5sa9oQLesV1vfrv1XRZb1CPBlOH8goovJBYf+v+nn6FMDeEYJ1L0crv5048je3ZZZ1QgIV4DvXgBOhG7ZDJWgk8RKq37gKVl0dazxxGvuq1CZH6mtfiu7ZO0z4Mbl++l5W3XB5eq2TmSki1rQhqoUwWAAEzecQx5wh16j4xWPR1l3le27/LevPunDWfZ1bb1mQfNxJ51rshMfpun+2fRAFVfXLhfGN28O7HtzIXz5xZS69nPMevolHus91Vxgn7dgJD7ETZ9Q6JAqr1P1ibf9hf/2jL/LDzbs5+qmW/rUX0bZkHku/MIeFXTkuTDl2VoCyH42+X2DfjiFe27yb5/v3M8H/6/wL7PmXA9rwTwYAAAAASUVORK5CYII=" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' <3\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEI0lEQVRIx8VVW0xUVxRd595z584MA1QGLJYqZVIFo3QaYksa+wBaabEaUyKtaJ8S+7Bq0s9W02Bj288mVmJrU42ElJJGbFSU0lYbSPUDg5IpAqkCoYrgDDIj87pzH7sfwDjDQIU0Tc/XPmevc9fe+66zN/AfL/ZPzrKVsJflY/2qbDz5UAbLNVlEOwBEQvrogJt62gfQdsaFk81dGJsXQcUqLP6wDHtzltk2y4vTTFJ6MhNsMhhjICICwAy/Qqp7nCmDo6G+PwO1n55GdWMHhu9JcORNVG542vJ10qNLbDwtaU5l0Dx+BC4Peo+1hqu21eL4rAQ/vo8dxcVp+20F2WCiwACAiIgxFsVN7WPPiYigE/Nf7Dd+Pud9e+NX+DaB4PNyrNn+yn1nbIUOEUDc5bkQMMYYGYTxC1e1mh/uPLv7OFqjBPlZkM9+xHsWlK7IZpL4r1RDER23W7qulnymrfhjCCoHgO3FeM2atyhbMPG4iL47oeBYs0pfVlvZAwuFuAyGRgzauTfINpZJ2LTOdDdLk0hJeZlLd5Rcr3y3DrUcAMoeYVvk7LT4SIjwxWEF3jsGGk5F8MFWc5y/oSkCV6+Ov4YMbFpnivPJ2Xasdd54HXVUywuWQE7NTHqCcXFKggAAXQf5xie2Yz6KdYGI6LaXQETk8wO6AYjCXQCTREpeaF39eE7AxB0ZcIgpZnn6j+WcsZXLRLh6NXIuF6MVmCqRc7lIDU0TGFFIFIWYYjE70gMOnmKBXZA5ReUWE+X+j61od2nY8JyUkEH58xJEAfSYk2Omu4LMkWKBnYMAEBgAYpOqokn7wUyGrEwpeh7rAwO9VCrF4afbAMB9IYwaigYYFPMs4m1VAxpbVPzeoQEAVhdwlJdKkPjMeIDBCGvwheDhfR5c030hBSqZCDFlmLSDYWDrnhAudetRdTW3amj8ScXhfRZYzfH4KVv3BcPX3OjjlwYR8Y4Ezyf51SLGRYpVKgAcqlfRcUWjaRKmjisaDtUrtKtSisMDAKk6+W4F2y4OTD60pk6qe2PpaJF8vz0h585ufdZW0dmtM/ILCTVSbnrYqU7UAgAHgJpzqKsodO/mUrKDiULco3kml3C+a+a2UJRHMHxa/APVdQSve3oPnMX3UYLum4gc/FXftksaajGnZgqTsRAAVDqBBQKosQPod098JCeDqLwAeCHfIMNrxJSeEPYNazW/6FU9w9AS2nXDO3hvjdN2QLZlMMbm2a5BTBm/pTdfDlRt/gZHZx04B7fg5YpC0yHZlp4qSpY5EeiRECkB91j9BfWtnfU4cc+Rud6JrD0vovrhReZXuWyTRckCJkrTaq1CV0PQlPFw7w3lyL4mfHLahZF5Df2SPKStnRj6T+VkINcqi3YGIKDonn43etoH0NbkwsnfeuHF/7X+Bkr5Nz1q0pkrAAAAAElFTkSuQmCC" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' o_o\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAE5klEQVRIx7VWe0yVZRj/Pd/lfIdzDshFAWUeDQUsdGJWztDmBUtRm+UEZbSltDI2c7Vybuly1bRmq5Thlq0yp043jSxApiEimrM0UqMhachBLiLQgXMO55zv9vQHcIRRErXevX+873P5fs/tfZ4P+J8X3Y/5wlykLpmKlTMnYk54pCWFFCkGADiod3jcau3lW6gqvYajn51D7YgAXl2EGa9k0M7oSVELlPHRkEc7iCQRAMDMTETEusFau5eCrg5uv/lH2a5T2LS7HL8MC1C6EZsenxXxrj3NKQk2yz8Kg+kLwlvt0s5d9Ly+vAAFfwtQ+QZ2PDwvbrMtNYGJiAZa3C8T8mAAnZkZAPVcvc2XzrZtm/8B3h4CsPc5rF69cvQhe5qTAIwYoI8G3+UGPlTUsXL9ARSFAGYnIrx4s3IjMuOhMRDov5WNYcJ96teWZTvV5As34ZMA4OV5WBc2JX4MicIQq0fiAQCwKHDYlLHj8uc1PH/hJgolAFg4VVijJESFjKj6UceJSg15WQomOYX7GlxTZ2DvkSCWL5CRkS4DAJTxUViY6soBuFCa9QBstlj7TIhCf7Jw7bqBY2UaH/9OQ94qBfm5CluVex9lZvb2AB9/4eeDx1UwA1OTxX51QBQ4LNbxaPpkT5g0IQaJYrhVGpjY/FyFM9Jl2l8UxKdHglx8WqWtG8KwYLYMZubSMxpt3xPgDjdT9lIL1q2y8IQEcVC4xHCrPDHGkyjZFUQJFokHlBuOntBwuFjl6/UGDINhtwnc0GSi30KvD5wQL+Bup8FHSlT8cEVHztMWzl1hCXkoWCTYFURLzDBhMoHB1FdV1TU6N7WalJ1pwTNPypyaJPZlsHdnZ8qUlSlzfaNJRSdVFFdoXN9oEvXxCSAwgxkmrUhD0v6tMXX2NGcIoFcORBig0B//vvtA+l+dvT+7kLe9I0n6rQ31epffxxrbGMCtJg3lF/yY7JThHCshNkaE3Ta4khiAYQCdXQaa23T83qhB1YDsTEeIr7t7vHVtqJdqmqHfbempdHSrS0iWuPysD1v2+CCKIhuGgShBhkUkFiwmIJoAE1gXmDQRPlNnDxsQRRFhcoCz5tt6e5OqcUerv+JKIwwJAIouY19+UvsS69gxtHiGFW+Rh+32CCIibIhL5qWRKSSQiIDpgwiZZcFCqhnk3XeqqayrFaqq8lOPgdhr9Hbz5nb66id8DgASAOw5g2O56e1XJUv49DhJwtqFFnxZ6YfNZhu2MzAzDNWLjYujYHbpMHUN3Y3tlworcDwE4OqE+X6JuXbbs03nrZHjrJsXh6H2VjdfbBj0toZcTJPZ0+3GrlwbnFaw4VYRcDf37Cjhta5OcAgAAApOozo5LpCTk9582Boeb9n3UgTtLOkBu4K9FUUEYgFE1PsgGRxj9dP+F22YmyIzGzoFuu/4D5wPriqsuDd4hrTON5di7sZF4gGrPcYpKg60fp/C1DiFBBo80VQzwI6Z1TQqqQV60MMBb2f9RyeNnPdO4OKwI/ORCXBsWYbX5iRL+d6GabFqbTpkUgbJ+E0voueUQXQ0tVRd1wveKcbuahd6RjT0U+IhZT6oPLFGzvowUho1XSIZDLDGAWo2bn/9jfHtrtJrqKq7A+Nf/VX0r9RRo+15idPWO20RM0xmraa7vfyTG1cOtgZ8PJzun2TyinIChzC3AAAAAElFTkSuQmCC" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' :P\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEaklEQVRIx8VVbUyVZRi+7vN+cTgHTnAOCFkgx5GogEaSZTr5yA9MbLOpadYyi7nIfufHD3JNa63NtTlbzaX4wzZXtlQwc6OEZRsY2JmfiDACBQ7gAc7L+Xg/7n4Ah3NiKv5o3b+e932u+7nu+3ru576B/9joYZtluXCW5aF8USaWzkqhObJVcAJAOGAMdHj5RmMH6ms9OH3uKu4/FsGGRXhqVxn2ZT1j36I8nSxLrgSy2BUQEZiZAZDpD7HmHaFQ50CgrVWt3l+Dqh/+RM8jCb7dhs2vLrN+ZVuYkSAm26Ylg97vh9rS6fv+YnD7e9U49UCCHyvxQXFx8pf2gkyQYCEAYGYmoghu4jv6PzMzTCZ/U7t5oc5X8dphHJlCcGA9Vry/6Yla+2K3AIC1e0M0eq0bbJictCrvkQRERGwyRi7d1g+dHC7dcwoXIwS5M6HU7RZvJK2cn0mSgHDXffgb26FkOGGdmw5LvDztquGwgcHzV2+XHtDne7qhiQBQWYyt8TnpmRZZJDBD9XSxNSed4uc9OW2JIhhZYFtOWnZlSdeWHcdxTASAsnzaqmQkj4tGSHjBDTHJhrt9Ji57dJQukRBvnVpwhsFoaNLR2mHirfUyZGkMo2Q6sSa/+02Aj4kFGZAdabYXSRImShBikg26Ad60048er4k1xTIf3GtFdBZNHgN7vwhwd6+J8lIJzBF3kCRwQmr8S89nqbKY5cJsITFOARCT8qCPqbefAYCvtRoRBZiZ/2g2aPsulXUd9Ow8AetellmRY+USHNY4t0t1i4lWOC2yyJFyG7dUJ3FhvoDGv3SsLZait+AbNvn1tTIcCcStHQYqdqs48qmNC/OFSBAWWUSiFS5xIisATONVxePr6s9t8A4yp6VEXTLAZcslWr1ciuDv9jI7Esdy5KhzAEAcCWLADOmAyVHPYmwtEDDDCcCMKcSJeCL49JTxlTm5bwZ1DAfQL97xos0YCoSgsczgqGMY9ZcNBEKMhTkCUpMm42IwBocYV26ZCGuMVUtE/NvXGAoE27y4Izb/jbCvd/R3m18rIlHg6FDP/abh5AUNANhmJTjsBCJgWGX2qwwGuOg5ESsKLBOhjzlqBg/1qQ2NHQiLAHCmhY+/nT1QpMxwxmj00UYB6rDJtY0mjQaB0SBPPjSAl+ZaaP87IthvxOgb6hmgs1dQHWkVc9Mg/7pLuJ7odrtJsCBGYICvdTL90sxo72OYDM50ERXnExfMJhpHRfBsGDzc1n6r6DMj7/o9aJHbrlqHkg9X287HOdIsDx9DD2tEjOBQj36wZrRk3xk0TGnX31Vgx8oF9kNKQgoRPWa7BlNopM/4uUV9d/M3OPrAgXP4DWzcsFj+WrG7HIJknRaBEQ5wSPXeP3FJ27bzBH565MgsX4CZe15BVXZ63FZRsSuCZAUJUqwahgZDC0APjQRvdoeOfnIWH9d40PtYQ78kB8lleSgvnIVlWS7MiVcEJwFQQ0Z/uxc3GjtQX+PB6bqb8OH/sn8A31pEhckzHzUAAAAASUVORK5CYII=" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' ;)\';" /><img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEOklEQVRIx8VVW2gcZRT+zsw/t93NJjt7iXY3za1pbau1UAqKNlZEFKGIIIJtRKtV+yA+WBAfKq1SBZ+KQvGCQi/qkxcwD0pfTFvxQUUKwaa2cU2bxDbJ3pJsZmd2LseHTTZZ0isq/k9zzvn++b7zcy7Af3zoWsEthhnvDZnbbtci96YVfY0my3EAcHw//5drnx10Zk+dtAr9pyrF4k0RPBxOZl6Mtb3Z0RLZ3pww1HCzSmpIQJIIzMzMIMfy2JquUmmqUvmzVD76Yeni/uNzucvXJXg7uebJhxKpD27pijaFm9UbeoZysYrL2ZnSd4WJ5/ZOnfv6qgSHWte/dF869V56dQskmQgAmJmJqI5bsJf6mZkDn2n891Lw/aXJF16eOPPJMoJXzM4Hn1nZ/u3KtTEZhIbLN0JARBQEjIu/Fb3DYyMPHCyMnKwT9Khh7VjbxrM9mxLtspD+UdV4boDzv+aGnx49vf5cdc4VALAjuqIvmQm3C0VepvpmMgAAoUicTId7dkyv2L4vd/6IAIDekNnXkjL+tdpvaTXQe8F8CjkcEevUiBpr0u6WFQnMzEuVXul7qX01jFAkbo5o92zQmlSRUfRuLSQ0AAzU0nxnZJwfT8WpO6QD4Lp/4Vc1e9Gfrdj8xUSeXu1I1+N6SOhtit4lIpIcl4VU1wQAjyVNvDUyxqYisC0Rw+ZohA1JasjBDgL8PFPm/lwR+aqH1zrSS5JgloWEMImE4IVy5UVFPYbGH9/WRf25Ivacv8AyQBldhSkEAHDB82nMdtgH6PWONLYlYkwgAmNZxmIu8POeG6DxlWuclh+AmeET4dG4iQ2REBjAYNnCu2OXQESo+AHAAF+hXMuBlxOjrv2HY3lO4EFthDE6VQ1EBBnA5nAEPboOANBZgiCCD6BD1RB4NfzSu86cZ496dlYMVcvVQtn58Vbb3yoUqQG1yQjjSHc3FCLuVDWwXwuvUjU+tmoVXGZebegLfl6inktzzg+DzmxVAMCAlT+WmYpubUmGqC5hvsu7hc4M0C8zcxiyKwDA63SD7jTCTAD5biMeAE9PVWjAyh+tj4ouJaR+2rZxKNNudkmy1HCh4Hu8d3KUzjiVhk5epxl8oLWNTEk04H0/4PGRwrm+sdN3ZF2rNiqyrlX9vDj+/LOqctxMNkkLEwAAvpzJY9ixebXQEZcFACDvezzs2PiqkOed0VRDr+UnZ7zPSuO7sq7lLhvXB1Nrd/fGUoeiTWHCPIs7X7/qIpQBUBXMBJCCxXE0O1P2B0pTu/ZMDh2+6sLZl+h54pFo60fhUKhZzNf9tYYdM8N1XbYqlWL/9OWdB/LD31x3Zd4fiqd3x1bu79QjfZqqakIIyLLcgPF9H67noVqt2lm7fPj94oU3TliFiZta+ncZLWZt6TdtyQh9jSHVln4l8HNjnn120J49dcIq9P9kl0r4v87faJg7jpVyacgAAAAASUVORK5CYII=" onclick="document.getElementById(\''+lblTxtEnviar+'\').value=document.getElementById(\''+lblTxtEnviar+'\').value+\' >:(\';" /></div></div></div></div><li class="left clearfix itemtemplate" style="display:none"><span class="chat-img pull-left"><img src="'+urlImg+'" alt="User Avatar" class="avatar" id="Foto"/></span><div class="chat-body clearfix"><div class="header"><strong class="primary-font" id="Nombre">Nombre</strong><small class="pull-right texto-pequeno"><span id="Tiempo"></span></small></div> <p id="Contenido" class="texto-padrao">Contenido</p></div></li>');
	
    $("#"+lblTxtEnviar).keyup(function (e) {if (e.keyCode == 13) { EnviarMensaje();}});
    $("#"+btnEnviar).click(function () {EnviarMensaje();});
	if(largura_tela > 768){$(".panel-body").height(altura_tela - 160+'px');}
        }
      
        function EnviarMensaje(){
			ws.send('{"to":"'+Room+'","Nombre":"'+Nombre+'","Contenido":"'+$('#'+lblTxtEnviar).val()+'"}');
			//timeout_button(3);
			$("#"+lblTxtEnviar).val('...');
			$("#"+lblTxtEnviar).prop('disabled', true);
			setTimeout(function() {
					$("#"+lblTxtEnviar).prop('disabled', false);
					$("#"+lblTxtEnviar).val('');
				}, 3000);
			  
        };
        function UsuarioOnline(){
           ws.send('{"to":"'+Room+'","Nombre":"'+Nombre+'"}');
		   var total_online = $('ul#listaOnline li').length;
		   $('#total_online').html(total_online);
        }
        function AgregarItem(Obj){
            
            if((Obj.Contenido!=null)&&(Obj.Nombre!=null)){
			
			// Filtra palavro
			var filterWords = ["c", "cu", "c u", "puta", "gay", "viado", "bicha", "bixa", "veado", "lesbica", "lsbica", "fuck", "bunda", "v i a d o", "puto"];
			var rgx = new RegExp(filterWords.join("|"), "gi");
			
			var mensagem = Obj.Contenido;
			var mensagem_final = mensagem.replace(rgx, "****");
			
			var mensagem_final = $("<div>").html(mensagem_final).text();
			
			// Filtra emoticons
			var emoticons = { '>:('  : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEOklEQVRIx8VVW2gcZRT+zsw/t93NJjt7iXY3za1pbau1UAqKNlZEFKGIIIJtRKtV+yA+WBAfKq1SBZ+KQvGCQi/qkxcwD0pfTFvxQUUKwaa2cU2bxDbJ3pJsZmd2LseHTTZZ0isq/k9zzvn++b7zcy7Af3zoWsEthhnvDZnbbtci96YVfY0my3EAcHw//5drnx10Zk+dtAr9pyrF4k0RPBxOZl6Mtb3Z0RLZ3pww1HCzSmpIQJIIzMzMIMfy2JquUmmqUvmzVD76Yeni/uNzucvXJXg7uebJhxKpD27pijaFm9UbeoZysYrL2ZnSd4WJ5/ZOnfv6qgSHWte/dF869V56dQskmQgAmJmJqI5bsJf6mZkDn2n891Lw/aXJF16eOPPJMoJXzM4Hn1nZ/u3KtTEZhIbLN0JARBQEjIu/Fb3DYyMPHCyMnKwT9Khh7VjbxrM9mxLtspD+UdV4boDzv+aGnx49vf5cdc4VALAjuqIvmQm3C0VepvpmMgAAoUicTId7dkyv2L4vd/6IAIDekNnXkjL+tdpvaTXQe8F8CjkcEevUiBpr0u6WFQnMzEuVXul7qX01jFAkbo5o92zQmlSRUfRuLSQ0AAzU0nxnZJwfT8WpO6QD4Lp/4Vc1e9Gfrdj8xUSeXu1I1+N6SOhtit4lIpIcl4VU1wQAjyVNvDUyxqYisC0Rw+ZohA1JasjBDgL8PFPm/lwR+aqH1zrSS5JgloWEMImE4IVy5UVFPYbGH9/WRf25Ivacv8AyQBldhSkEAHDB82nMdtgH6PWONLYlYkwgAmNZxmIu8POeG6DxlWuclh+AmeET4dG4iQ2REBjAYNnCu2OXQESo+AHAAF+hXMuBlxOjrv2HY3lO4EFthDE6VQ1EBBnA5nAEPboOANBZgiCCD6BD1RB4NfzSu86cZ496dlYMVcvVQtn58Vbb3yoUqQG1yQjjSHc3FCLuVDWwXwuvUjU+tmoVXGZebegLfl6inktzzg+DzmxVAMCAlT+WmYpubUmGqC5hvsu7hc4M0C8zcxiyKwDA63SD7jTCTAD5biMeAE9PVWjAyh+tj4ouJaR+2rZxKNNudkmy1HCh4Hu8d3KUzjiVhk5epxl8oLWNTEk04H0/4PGRwrm+sdN3ZF2rNiqyrlX9vDj+/LOqctxMNkkLEwAAvpzJY9ixebXQEZcFACDvezzs2PiqkOed0VRDr+UnZ7zPSuO7sq7lLhvXB1Nrd/fGUoeiTWHCPIs7X7/qIpQBUBXMBJCCxXE0O1P2B0pTu/ZMDh2+6sLZl+h54pFo60fhUKhZzNf9tYYdM8N1XbYqlWL/9OWdB/LD31x3Zd4fiqd3x1bu79QjfZqqakIIyLLcgPF9H67noVqt2lm7fPj94oU3TliFiZta+ncZLWZt6TdtyQh9jSHVln4l8HNjnn120J49dcIq9P9kl0r4v87faJg7jpVyacgAAAAASUVORK5CYII=', ':)' : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAFAklEQVRIx8VVaWxUZRQ9960zfdMZ22mhFLqSAg0UlCWoFaVlsZVUsYoGxESiYLXgPzVIDAWJWBKTxqRiXMKaYIIKCrSyWaWVaqrS2rAUaFrALlAK05lOZ9685fqj0gWCwA/j9+flvXffd+53znnnAv/xon97mT8J3vwsFExPwSOp8TRecYpeAIiErO7WLj5T14rqykbs+/4krt8TwKLpGLM6H+vTxrmWqEmxihwXTYJLBRGBmRkA2b06G10B0i92h5rPBbe/X4GSb/5A5x0BtizD4qdmOT/R7k+OlmK1u6LBvNqLYP1F39fHwi8v3449twXYW4yVOTmxH7mmpoBEgQCAmZmIBupu3A99zswMm6n3txb7SJVvxTOb8cUtABsLMe/15++rdM1MFwEM+/huAIiI2GYEas+b5bv9c9bswbEBgEmjoVa9I52JmT8xhWQRANATYJTv1NF+2cbCeQrmZkvDaNl72MDhagNjU0W8tkSF0/FPAxEL1w6dPD9nozmxsQ2GBADFOVgaNWFUiqBIAx0Vr+2juj8tMDMfrjFpy6YoZE+Twcy876hBb5eGGAAdOW7iUrvNZe9G9Z9SEVmbkJBRnPvXkqId2CYBQP5kWqomxw50FwoD9acsLMiR8WyejFXr+vDLCQvZ02QAwM+/m4iLIXy0Ngof79RRe8Icdjo1xYsnJre9CPA2mpoM5egGl9/96DhlaNE1HyPGQyAC/L0MzUkQ+9mDHgEiBhCtAZYFBEMMt2u4If0/NemPlwQ9Ulocxopuh3qzsN6YQRd5ooVhIjtUIlXpF1aSALfrVlOIHqcjPS6YLrmd8AqKxADBV9XKIBGCakCIUlhwyBBUCSSLTKIAEAFgwAazZYMNk23dhB0yYPfpbJvREJ1huGYks6BIcDsRJzHfsCtzee1oWli8E5lpXrYDF8jubQeHu9nWewhmCGybAIFJUIgcUUxuD0nOeAiuRBaiU6nm13qcOrici2YM2l8KhNFt6yZgMxSviacLC5GZmYm8vDxkZ2cjM7MADmVQHma+ERno6+tDQ0MDqr86isrKSrS1taH0TRdgA3bYhD+Eq/RAEpQf3tP87ocylG4fU/6rQfgCgz+RLMuclJREI0aMgKZpYGYOBALU0dHB7e3tZNv2AO+piYT9mzWWJZD/+Lnw/HVBj3TiEiK+y33HtV5jdoxD5A9WqijepMOy+smLRCJobm7m5ubmoSbhm65QZXDpKhWiacMKWdxzJVhT14qIBAD763nHSxnds9WRXnosE/iwSObVnxsUjvRv8uDIeJo7JhEp0RosZj7r89OBC5e4yecnANAc4LJimbISGdxrsd7ZTQcasH0gKjIToPy4WjztTk9PJ1EAAG7pZCr71sKCpDA/7J1MMBIAS+vvWgwQyx28u7WR6ns0vFUo8pi4/r3Ystjf3HJ2dqmVdboDxoDaJU8i94087ZDDkyAMzVjbMGCGe2GbkX4XASBBgiCpkBwaBFkeQhwj3NNpllX05a7fj5pb4vrLFSiaP8VVrkbHE9E9xjWY9MAV62B98JXFn2HrbQfO5hfw3KKZyqeqK84jys67ArAiIdaDXdd31RrLVu3Cd3ccmQVTMHrNApRkjHIslVSXKspOkCgPq2HLgGWEYOqBcFObvnXDAayraMTlexr6uRMQm5+FghmpmJUWh/FRquglAEHdutrShTN1raiuaMS+qib48H+tvwGZeHvbKgF5fgAAAABJRU5ErkJggg==', ':P' : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAE5klEQVRIx7VWe0yVZRj/Pd/lfIdzDshFAWUeDQUsdGJWztDmBUtRm+UEZbSltDI2c7Vybuly1bRmq5Thlq0yp043jSxApiEimrM0UqMhachBLiLQgXMO55zv9vQHcIRRErXevX+873P5fs/tfZ4P+J8X3Y/5wlykLpmKlTMnYk54pCWFFCkGADiod3jcau3lW6gqvYajn51D7YgAXl2EGa9k0M7oSVELlPHRkEc7iCQRAMDMTETEusFau5eCrg5uv/lH2a5T2LS7HL8MC1C6EZsenxXxrj3NKQk2yz8Kg+kLwlvt0s5d9Ly+vAAFfwtQ+QZ2PDwvbrMtNYGJiAZa3C8T8mAAnZkZAPVcvc2XzrZtm/8B3h4CsPc5rF69cvQhe5qTAIwYoI8G3+UGPlTUsXL9ARSFAGYnIrx4s3IjMuOhMRDov5WNYcJ96teWZTvV5As34ZMA4OV5WBc2JX4MicIQq0fiAQCwKHDYlLHj8uc1PH/hJgolAFg4VVijJESFjKj6UceJSg15WQomOYX7GlxTZ2DvkSCWL5CRkS4DAJTxUViY6soBuFCa9QBstlj7TIhCf7Jw7bqBY2UaH/9OQ94qBfm5CluVex9lZvb2AB9/4eeDx1UwA1OTxX51QBQ4LNbxaPpkT5g0IQaJYrhVGpjY/FyFM9Jl2l8UxKdHglx8WqWtG8KwYLYMZubSMxpt3xPgDjdT9lIL1q2y8IQEcVC4xHCrPDHGkyjZFUQJFokHlBuOntBwuFjl6/UGDINhtwnc0GSi30KvD5wQL+Bup8FHSlT8cEVHztMWzl1hCXkoWCTYFURLzDBhMoHB1FdV1TU6N7WalJ1pwTNPypyaJPZlsHdnZ8qUlSlzfaNJRSdVFFdoXN9oEvXxCSAwgxkmrUhD0v6tMXX2NGcIoFcORBig0B//vvtA+l+dvT+7kLe9I0n6rQ31epffxxrbGMCtJg3lF/yY7JThHCshNkaE3Ta4khiAYQCdXQaa23T83qhB1YDsTEeIr7t7vHVtqJdqmqHfbempdHSrS0iWuPysD1v2+CCKIhuGgShBhkUkFiwmIJoAE1gXmDQRPlNnDxsQRRFhcoCz5tt6e5OqcUerv+JKIwwJAIouY19+UvsS69gxtHiGFW+Rh+32CCIibIhL5qWRKSSQiIDpgwiZZcFCqhnk3XeqqayrFaqq8lOPgdhr9Hbz5nb66id8DgASAOw5g2O56e1XJUv49DhJwtqFFnxZ6YfNZhu2MzAzDNWLjYujYHbpMHUN3Y3tlworcDwE4OqE+X6JuXbbs03nrZHjrJsXh6H2VjdfbBj0toZcTJPZ0+3GrlwbnFaw4VYRcDf37Cjhta5OcAgAAApOozo5LpCTk9582Boeb9n3UgTtLOkBu4K9FUUEYgFE1PsgGRxj9dP+F22YmyIzGzoFuu/4D5wPriqsuDd4hrTON5di7sZF4gGrPcYpKg60fp/C1DiFBBo80VQzwI6Z1TQqqQV60MMBb2f9RyeNnPdO4OKwI/ORCXBsWYbX5iRL+d6GabFqbTpkUgbJ+E0voueUQXQ0tVRd1wveKcbuahd6RjT0U+IhZT6oPLFGzvowUho1XSIZDLDGAWo2bn/9jfHtrtJrqKq7A+Nf/VX0r9RRo+15idPWO20RM0xmraa7vfyTG1cOtgZ8PJzun2TyinIChzC3AAAAAElFTkSuQmCC', 'o_o'  : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEI0lEQVRIx8VVW0xUVxRd595z584MA1QGLJYqZVIFo3QaYksa+wBaabEaUyKtaJ8S+7Bq0s9W02Bj288mVmJrU42ElJJGbFSU0lYbSPUDg5IpAqkCoYrgDDIj87pzH7sfwDjDQIU0Tc/XPmevc9fe+66zN/AfL/ZPzrKVsJflY/2qbDz5UAbLNVlEOwBEQvrogJt62gfQdsaFk81dGJsXQcUqLP6wDHtzltk2y4vTTFJ6MhNsMhhjICICwAy/Qqp7nCmDo6G+PwO1n55GdWMHhu9JcORNVG542vJ10qNLbDwtaU5l0Dx+BC4Peo+1hqu21eL4rAQ/vo8dxcVp+20F2WCiwACAiIgxFsVN7WPPiYigE/Nf7Dd+Pud9e+NX+DaB4PNyrNn+yn1nbIUOEUDc5bkQMMYYGYTxC1e1mh/uPLv7OFqjBPlZkM9+xHsWlK7IZpL4r1RDER23W7qulnymrfhjCCoHgO3FeM2atyhbMPG4iL47oeBYs0pfVlvZAwuFuAyGRgzauTfINpZJ2LTOdDdLk0hJeZlLd5Rcr3y3DrUcAMoeYVvk7LT4SIjwxWEF3jsGGk5F8MFWc5y/oSkCV6+Ov4YMbFpnivPJ2Xasdd54HXVUywuWQE7NTHqCcXFKggAAXQf5xie2Yz6KdYGI6LaXQETk8wO6AYjCXQCTREpeaF39eE7AxB0ZcIgpZnn6j+WcsZXLRLh6NXIuF6MVmCqRc7lIDU0TGFFIFIWYYjE70gMOnmKBXZA5ReUWE+X+j61od2nY8JyUkEH58xJEAfSYk2Omu4LMkWKBnYMAEBgAYpOqokn7wUyGrEwpeh7rAwO9VCrF4afbAMB9IYwaigYYFPMs4m1VAxpbVPzeoQEAVhdwlJdKkPjMeIDBCGvwheDhfR5c030hBSqZCDFlmLSDYWDrnhAudetRdTW3amj8ScXhfRZYzfH4KVv3BcPX3OjjlwYR8Y4Ezyf51SLGRYpVKgAcqlfRcUWjaRKmjisaDtUrtKtSisMDAKk6+W4F2y4OTD60pk6qe2PpaJF8vz0h585ufdZW0dmtM/ILCTVSbnrYqU7UAgAHgJpzqKsodO/mUrKDiULco3kml3C+a+a2UJRHMHxa/APVdQSve3oPnMX3UYLum4gc/FXftksaajGnZgqTsRAAVDqBBQKosQPod098JCeDqLwAeCHfIMNrxJSeEPYNazW/6FU9w9AS2nXDO3hvjdN2QLZlMMbm2a5BTBm/pTdfDlRt/gZHZx04B7fg5YpC0yHZlp4qSpY5EeiRECkB91j9BfWtnfU4cc+Rud6JrD0vovrhReZXuWyTRckCJkrTaq1CV0PQlPFw7w3lyL4mfHLahZF5Df2SPKStnRj6T+VkINcqi3YGIKDonn43etoH0NbkwsnfeuHF/7X+Bkr5Nz1q0pkrAAAAAElFTkSuQmCC', ':('  : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEPUlEQVRIx8VVa0xTZxh+3nNOz2lpaQkto4piqSGAskFkIzNOIWCMskt2YRcTtjk2tylkP7Y/xjAjcRr3Zz82nTMmRsEsi4nRxbFMF8emmzNh2TBIYEECc+MiUCiX0tOenvPuB6WhMG5Zln2/vsv7vc/z3oH/eNFCj9tz4dyRiyce9uAxj4uylATRCQChoO7rHuT2pm7c+LoFl6+2wr8sgPICrNpfhoMZmbYKZXWybEpJJMGmgIjAzAwGGQGVtcFxCt0bDnZ2BM4ebkDtxd/QvyjA6V146ektlpPW/PREKdm6JDdEhiYQaL7nv3Bdrdxdh0vzAlzci6qSkuRPbBvWgESBAICZmYhictPnmffMzNCZJn7pMr5t9O8u/wyn5wAceQZbq15M+sb2qFcEEPd5KQBERGwwxn++Gzl2fqy05hKuxwBy06B8t19qS9623kMm8V9lDYd1DF9tvVtyJLL+Ti80CQD2FqPCmu32CLIUYxT8vZ8EkwjFm7KgBWrnAAxNZ0uWe0pMFtma7c6sLv1r59v1qJMAoCyPKpR0JwBgsrUH4f5R6OMq7JsyF2Us2i0I/NSBcM8IZLcDlnUroaxxouyhnlcArpM2pEN2uBM2kkmcChYRTKkOJBZmsGAzx1jHuSF6ZmaWXDYkleZA/WOYETWUTCInPpCwqTAjIEsZLqwV7RZlOrAJ61binwK4UJAFm5mtuWlx8qLDYva6Al7JboFTkCWeyWzAx0iyg2XTlNIBn8HJDoIYjX9YYx72M1JdYADQIsDYhMHOJIqREGQJdgtcUtR4AsAUzar3Pwqyz8/0WrmM3gHm4/UqfXwgAUWFEhjgW79GqLp2kqsqFFrlFnDmQpiTk4hOfpAAnqEHAKRxFT4jFAEMjpXFgSoz3jsaxLuHgzDLwK5nZWwpEAEDABibC0RUPifj+LkQ1BCQnyOiZo859g4QDDWCsSCGKH815MZD1jH7xkx5RuExABoPMMwysckUV/HTTFjTQGqYkWglnv137GaHuq024JCa/0TYf3/ypnVCKyZJnJktbBUB6AxDB8+uJwAQozKGyrE7AGBN59GBwI9N3QhLANBwm8+9mukrVlKdNIvl7H2cBfPIcKjfRw23URdrFTkrIH+/T2yze71eEoU5H/bVG/TDHY4DKMolPvqyMAeAdZ3HOrs6ij/Uc9v6oq2irQ/hE9f0N98x9V4xO9xCVHVMY5EH7BDiXZSfzjD8RpxLwYA62hf59Jr+elsftDnt+vxb2LM1z3ZMsaUQ0TLbNZhC4wP6lebAGztP4cy8A+dEBV54vlA+pdhcdtFkWRKAHg5yKDA48sUtrbL6c3y56Mh8Kg9pNY+jdu0Kc4Wk2GRRtoAEU7yPdA26FkQkNKF29KpnD32Fgw0tuL+soV+aDeeOB/HkIx5sznAhy6JMDf1gWB/qGkR7UzduNLTgcmM7RvB/rb8B/Oka3QhY3yYAAAAASUVORK5CYII=', '<3'  : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAFM0lEQVRIx8WVW4xV5RXHf2vv75y995lzZoY5B4ujzDCHjtdBLZ2WaosOoiZoCalEjRbTWkURtGnSvlj7YBt7ebAvbSmNjRHpBRPTilWhNJpRNKUJpKKIgA7jgMIMnBnmcq5777P36sMBZLDU+tD0e/mSb13+X9Z/rf+C//GR/2Rc0kN2yTyW9nbylTkz5cKkZ2cBgmo0NlTQfTuGeG3Lbp7/6x7GPxXALb2c/9ASftR1QfoOZ3ZbMpHLiJV2EBFUVQGJS76GhaL4h8aqB94rb/jJZh758z8Z+USAJ+/i9mULvd80XdGRMW1N/1UZ6qMlyrsOTfxpW+3ulRt49qwAm9bwwKJFbb9Iz+9EbEsAVFGRj/xUVUVETt4n34hVSjvfj1/qn7h3+Tqe+BjAT2/m+tW3tW5JL8jbgPpHE/Lm99op7mxRd25ZLnvsMM0X+6iqFve78vZD7VodTEnrgknm/WxYk22RaKwUtw/U1z4ztfjhZ9l2CqDnPJwtK1P7ju3s66wcbKLtqhJT77iwpxNjDHEcU205zMKXB0Bh2+JuUlPtWJZFGIbYnx/Caw8Z357B6ygx68pXBm56snzp7sOEBmBNHysGnujrdMrd4poExzfWtFKrSHZGAlVV27Yl/DBDMGYTh6L1I2mxmi0VEUkmk4y9mtUw1SRNjkv4RqgD+6R7zaIX7lj1e54yAIs7vBUHj7WTaU0C4LoujuNMI1KtCNMUo5GgxNNsM1pnYFkWAMYYotFZXNfh3QnVp8z8DpLZvLnyoBecbMEGOQ0eAYiiSDPzJ7DcRuL0FRMaD7RiWZae8J0WS5OvM/L2l7/YRdJ05ZibmOk4XQ8O66Gfe5JJZwCmdUipXJKe+8ZOJcrfPyp7VuW0pblFzugspopTOvf7w5LIuW4+V8qbZo+slTTadfdx4kD04C/PJ+01Y2yjAEEQ0HLtiOauLnPykzOvKWvr9cNUtznqJBulDOuhlqqTdH33QzrvHNfqO4Zmj5w5ESOgmv/WhGQvEQbWVXR8V0qchEucO669Px4RoeGooIJKz6Mj+o/lKamMZAlCXzOXlWX+A+O0LJhUQU+1vynWGIv9OsQKoZBqVy5dHVE7EnJ8sMg5N4xjUjEf8aqAYFzlc4+NMrwppu2zLt7sCPvcRg4SENfqTFUZNYMFDkSTVZ9Qk1DHSgRouoI3J2B2j4+draJRBKdxqCgaK+45NTqWF4lLAZJsxEIdDWOiyWrtQIFB88YHBBNHK39vKoV9YscqqSI2ARpZKsk6a58r8vgmXy/OW1zQYaHAe4di3TsYc9/XAr3/xgjxDI1YH62HxLVIJ4+VX98xRGAAXtilv/tm91if85msQIQYX8UgCPxxq69hHXnr3Zi33o2nadHGrb6s/qogzom6hYqGqD8yJi++yQYAA/Drfv5w65cKPzCJTF5sa9oQLesV1vfrv1XRZb1CPBlOH8goovJBYf+v+nn6FMDeEYJ1L0crv5048je3ZZZ1QgIV4DvXgBOhG7ZDJWgk8RKq37gKVl0dazxxGvuq1CZH6mtfiu7ZO0z4Mbl++l5W3XB5eq2TmSki1rQhqoUwWAAEzecQx5wh16j4xWPR1l3le27/LevPunDWfZ1bb1mQfNxJ51rshMfpun+2fRAFVfXLhfGN28O7HtzIXz5xZS69nPMevolHus91Vxgn7dgJD7ETZ9Q6JAqr1P1ibf9hf/2jL/LDzbs5+qmW/rUX0bZkHku/MIeFXTkuTDl2VoCyH42+X2DfjiFe27yb5/v3M8H/6/wL7PmXA9rwTwYAAAAASUVORK5CYII=', ';)'  : 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAA7EAAAOxAGVKw4bAAAEaklEQVRIx8VVbUyVZRi+7vN+cTgHTnAOCFkgx5GogEaSZTr5yA9MbLOpadYyi7nIfufHD3JNa63NtTlbzaX4wzZXtlQwc6OEZRsY2JmfiDACBQ7gAc7L+Xg/7n4Ah3NiKv5o3b+e932u+7nu+3ru576B/9joYZtluXCW5aF8USaWzkqhObJVcAJAOGAMdHj5RmMH6ms9OH3uKu4/FsGGRXhqVxn2ZT1j36I8nSxLrgSy2BUQEZiZAZDpD7HmHaFQ50CgrVWt3l+Dqh/+RM8jCb7dhs2vLrN+ZVuYkSAm26Ylg97vh9rS6fv+YnD7e9U49UCCHyvxQXFx8pf2gkyQYCEAYGYmoghu4jv6PzMzTCZ/U7t5oc5X8dphHJlCcGA9Vry/6Yla+2K3AIC1e0M0eq0bbJictCrvkQRERGwyRi7d1g+dHC7dcwoXIwS5M6HU7RZvJK2cn0mSgHDXffgb26FkOGGdmw5LvDztquGwgcHzV2+XHtDne7qhiQBQWYyt8TnpmRZZJDBD9XSxNSed4uc9OW2JIhhZYFtOWnZlSdeWHcdxTASAsnzaqmQkj4tGSHjBDTHJhrt9Ji57dJQukRBvnVpwhsFoaNLR2mHirfUyZGkMo2Q6sSa/+02Aj4kFGZAdabYXSRImShBikg26Ad60048er4k1xTIf3GtFdBZNHgN7vwhwd6+J8lIJzBF3kCRwQmr8S89nqbKY5cJsITFOARCT8qCPqbefAYCvtRoRBZiZ/2g2aPsulXUd9Ow8AetellmRY+USHNY4t0t1i4lWOC2yyJFyG7dUJ3FhvoDGv3SsLZait+AbNvn1tTIcCcStHQYqdqs48qmNC/OFSBAWWUSiFS5xIisATONVxePr6s9t8A4yp6VEXTLAZcslWr1ciuDv9jI7Esdy5KhzAEAcCWLADOmAyVHPYmwtEDDDCcCMKcSJeCL49JTxlTm5bwZ1DAfQL97xos0YCoSgsczgqGMY9ZcNBEKMhTkCUpMm42IwBocYV26ZCGuMVUtE/NvXGAoE27y4Izb/jbCvd/R3m18rIlHg6FDP/abh5AUNANhmJTjsBCJgWGX2qwwGuOg5ESsKLBOhjzlqBg/1qQ2NHQiLAHCmhY+/nT1QpMxwxmj00UYB6rDJtY0mjQaB0SBPPjSAl+ZaaP87IthvxOgb6hmgs1dQHWkVc9Mg/7pLuJ7odrtJsCBGYICvdTL90sxo72OYDM50ERXnExfMJhpHRfBsGDzc1n6r6DMj7/o9aJHbrlqHkg9X287HOdIsDx9DD2tEjOBQj36wZrRk3xk0TGnX31Vgx8oF9kNKQgoRPWa7BlNopM/4uUV9d/M3OPrAgXP4DWzcsFj+WrG7HIJknRaBEQ5wSPXeP3FJ27bzBH565MgsX4CZe15BVXZ63FZRsSuCZAUJUqwahgZDC0APjQRvdoeOfnIWH9d40PtYQ78kB8lleSgvnIVlWS7MiVcEJwFQQ0Z/uxc3GjtQX+PB6bqb8OH/sn8A31pEhckzHzUAAAAASUVORK5CYII=' }
			
			for ( smile in emoticons ) {
				mensagem_final = mensagem_final.replace(smile, '<img src="' + emoticons[smile] + '" width="20" height="20" border="0" align="absmiddle" />');
			}
                
            $( ".itemtemplate" ).clone().appendTo( ".chatpluginchat" );
            $('.chatpluginchat .itemtemplate').show(10);
            $('.chatpluginchat .itemtemplate #Nombre').html(Obj.Nombre);
            $('.chatpluginchat .itemtemplate #Contenido').html(mensagem_final);
             
             var formattedDate = new Date();
             var d = (formattedDate.getDate() < 10 ? '0' : '') + formattedDate.getDate();
			 var m = (formattedDate.getMonth() + 1);
             var m = (m < 10 ? '0' : '') + m;
             var y = formattedDate.getFullYear();
             var h= formattedDate.getHours();
             var mn= (formattedDate.getMinutes() < 10 ? '0' : '') + formattedDate.getMinutes();
            
            Fecha=d+"/"+m+"/"+y+" "+h+":"+mn;
            
            $('.chatpluginchat .itemtemplate #Tiempo').html(Fecha);
            $('.chatpluginchat .itemtemplate').removeClass("itemtemplate");
			
			// Scroll
			var height = 0;
			$('.panel-body ul li').each(function(i, value){
				height += parseInt($(this).height());
			});
			
			height += '';
			
			$('.panel-body').animate({scrollTop: height});
			
            }
        }
           function getOnline() {
                setInterval(UsuarioOnline, 1000);
            }
           
         
         CrearEntrada();
    // Fin
	
	function timeout_button(time){
		var n=time;
		var c=n;
		$("#"+lblTxtEnviar).val(c);
		setInterval(function(){
			c--;
			if(c>=0){
				$("#"+lblTxtEnviar).val(c);
			}
			if(c==0){
				$("#"+lblTxtEnviar).val(n);
			}
		},1000);
	}
	
	}
});